/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StoreItemServiceTest
 * @Package cn.freemud.service
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/29 14:53
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service;

import cn.freemud.entities.dto.GetProductInfoDto;
import cn.freemud.entities.dto.ProductInfosDto;
import cn.freemud.entities.vo.GetProductsVo;
import cn.freemud.service.thirdparty.ProductClient;
import com.google.common.collect.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class StoreItemServiceTest {

    @Autowired
    private ItemService itemService;
    @Autowired
    private ProductClient storeItemClient;


    @Test
    public void findProductGroupVoByProductIdsTest(){

        String partnerId="360bb48b-5316-458a-903e-9a44c7f339b1";
        String shopId="1036";
        List<String> productIds= Lists.newArrayList();
        productIds.add("108626130583421196");
        productIds.add("107901007203140097");
        GetProductInfoDto getProductInfoDto = new GetProductInfoDto();
        getProductInfoDto.setPartnerId(partnerId);
        getProductInfoDto.setShopId(shopId);
        getProductInfoDto.setProductInfoType(2);
        getProductInfoDto.setProductIds(productIds);
        ProductInfosDto productInfosDto=  storeItemClient.listProductInfos(getProductInfoDto);
        System.out.println("json=="+productInfosDto );
    }




    @Test
    public void getProductsTest() {
        Map<String, GetProductsVo> getProductsVoMap = itemService.getProducts(Arrays.asList("125115354620910094",
                "125115354620910098",
                "125115354620910102",
                "125117293812275722",
                "125117293812275726",
                "125117293812275730"), "1864", "1001","saas");
        System.out.println(getProductsVoMap);
    }


}
