package cn.freemud.entities.db;

import cn.freemud.comm.entity.BaseEntity;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Data
@Table(name = "open_platform_wxapp_pay_ebcode")
public class OpenPlatformWxappPayEbcode extends BaseEntity implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 微信appid
     */
    @Column(name = "wx_appid")
    private String wxAppid;

    /**
     * 品牌ID
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 支付payebCode
     */
    @Column(name = "pay_ebcode")
    private String payEbCode;
    /**
     * 微信支付商户号
     */
    @Column(name = "mch_id")
    private String mchId;

    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;
}