package cn.freemud.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.4.1
 * @Title: PlatformType
 * @Package cn.freemud.enums
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2018/11/14 14:35
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum PlatformType {

    WXAPP_PAYMENT("xcxmicro","微信小程序"),
    YF_PAYMENT("xcxyoufupay","优赋小程序支付");

    private String code;
    private String message;

    PlatformType(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public static PlatformType getByCode(String type){
        for(PlatformType platformType:values()){
            if(platformType.getCode().equals(type)){
                return platformType;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
