/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderCancelReq
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/2 21:26
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.request;

import com.freemud.application.sdk.api.ordercenter.request.create.OrderTaskReq;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class OrderCancelReq {

    //必填参数
    private String partnerId;

    private String orderCode;

    //第三方订单编码，与orderCode二选一，三平台订单号,例如百度、饿了么、美团
    private String thirdOrderCode;

    //必填参数
    //售后单类型 1:其他取消 2:用户取消 3:商户取消 4:未支付超时关单 5:商户接单超时取消 6:商家拒单 7:配送用户拒收
    // 8:用户售后退货/售后退款 9:系统取消 10:客服取消 11:用户统一取消，相当于USER_CANCEL以及USER_SALE_RETURN包含的场景，内部会根据状态解析成具体类型
    private Integer afterSalesType;

    //若为null，默认只做【创建】，售后单状态为【待处理】
    //若为2，默认做【创建】+【审核通过】，售后单状态为【退货中】
    //若为5，默认做【创建】+【同意并退货完成】，售后单状态【已退货】
    //若为4，默认做【创建】+【同意并退款完成】，售后单状态为【完成】
    private Integer createEvent;
    /**
     *售后原因
     */
    private String afterSalesReason;
    /**
     * 用户自身描述的取消原因
     */
    private String reqRemark;

    private String cancelReason;

    //必填参数
    //下单渠道 1:自营微信小程序 2:SAAS,i应用
    private Integer orderClient;

    private Integer ver;

    /**
     * 退款流水号
     */
    private String afterSerialNo;

    //操作人
    private String operator;

    private Integer timeOut;

    /**
     * 是否退配送费
     */
    private boolean isRefundDeliveryAmount;

    //任务
    private OrderTaskReq orderTask;

    /**
     * 拓展信息
     */
    private String extInfo;

    /**
     * 操作来源客户端 1:POS插件 2:小助手 3:开放平台 4:自动任务 5:用户端 6:系统 7:万象 8:太一
     */
    private Integer operationClient;

    /**
     * 售后退款状态 0:未定义（存量数据） 1:未退款 2:退款中 3:退款失败 4:已退款
     */
    private Integer refundState;

    /**
     * 部分退申请金额
     */
    private BigDecimal reqAmount;

    /**
     * 是否部分退,默认否(全退)
     */
    private boolean isPartRefund = false;
}
