package cn.freemud.management.adapter;

import cn.freemud.management.entities.dto.request.pay.AgentPayRefundReq;
import cn.freemud.management.entities.dto.request.pay.PayRefundRequestDto;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import com.freemud.sdk.api.assortment.order.request.order.MultiOrderRefundRequest;
import lombok.SneakyThrows;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PaymentSdkAdapter
 * @Package cn.freemud.management.adapter
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/24 11:45
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class PaymentSdkAdapter {

    @Value("${saas.refund.notify.callback}")
    private String refundNotifyCallback;

    public PayRefundRequestDto getOrderRefundRequest(String partnerId, String storeCode, String orderCode,
                                                     BigDecimal refundAmount, String payNo, String extInfoStr, String reason) {
        PayRefundRequestDto refundRequestDTO = new PayRefundRequestDto();
        refundRequestDTO.setPartnerId(partnerId);
        refundRequestDTO.setStoreId(storeCode);
        refundRequestDTO.setOrgTransId(orderCode);
        refundRequestDTO.setRefundAmount(refundAmount.longValue());
        refundRequestDTO.setNotifyUrl(refundNotifyCallback);
        OrderExtInfoDto orderExtInfoDto = JSONObject.parseObject(extInfoStr, OrderExtInfoDto.class);
        refundRequestDTO.setAppId(orderExtInfoDto.getAppid());
        // 为空从extinfo中获取
        if (StringUtils.isBlank(payNo) || Objects.equals("0", payNo)) {
            payNo = orderExtInfoDto.getFmId();
        }
        refundRequestDTO.setOrgPayFmId(payNo);

        refundRequestDTO.setOpenid(orderExtInfoDto.getOpenid());
        refundRequestDTO.setRefundId(getRefundSerialNo().toString());
        refundRequestDTO.setRefundDesc(StringUtils.isNotBlank(reason) ? reason : "商家退款");
        return refundRequestDTO;
    }

    public PayRefundRequestDto convert2OrderRefundNewRequest(OrderBeanV1 order, OrderExtInfoDto orderExtInfoDto) {
        PayRefundRequestDto refundRequest = new PayRefundRequestDto();
        refundRequest.setPartnerId(order.getCompanyId());
        refundRequest.setVer(2);
        refundRequest.setStoreId(order.getShopId());
        refundRequest.setStationId("1");
        refundRequest.setTransId(order.getOid());
        refundRequest.setFmId(orderExtInfoDto.getFmId());
        refundRequest.setRefundId(UUID.randomUUID().toString());
        refundRequest.setTotalAmount(Long.valueOf(orderExtInfoDto.getSvcAmount()));
        refundRequest.setRefundAmount(Long.valueOf(orderExtInfoDto.getSvcAmount()));
        return refundRequest;
    }

    @SneakyThrows
    public MultiOrderRefundRequest getMultiOrderPayRefundRequest(String partnerId, String storeCode, String orderCode, BigDecimal refundAmount) {
        MultiOrderRefundRequest multiQueryRequest = new MultiOrderRefundRequest();
        multiQueryRequest.setStationId("1");
        multiQueryRequest.setPartnerId(partnerId);
        multiQueryRequest.setStoreId(storeCode);
        multiQueryRequest.setFmId("");
        multiQueryRequest.setRefundAmount(Long.valueOf(String.valueOf(refundAmount)));
        multiQueryRequest.setRefundTradeNo(String.valueOf(getRefundSerialNo()));
        multiQueryRequest.setNotifyUrl(refundNotifyCallback);
        multiQueryRequest.setVer("V1");
        multiQueryRequest.setVer3(false);
        multiQueryRequest.setOutOrderNo(orderCode);
        return multiQueryRequest;
    }

    @SneakyThrows
    public AgentPayRefundReq getAgentPayRefundReq(String partnerId, String storeCode, String orderCode, BigDecimal refundAmount, String fmTradeNo) {
        AgentPayRefundReq req = new AgentPayRefundReq();
        req.setPartnerId(partnerId);
        req.setStoreId(storeCode);
        req.setFmTradeNo(fmTradeNo);
        req.setOutOrderNo(orderCode);
        req.setRefundTradeNo(this.getRefundSerialNo().toString());
        req.setRefundAmount(refundAmount.longValue());
        req.setNotifyUrl(refundNotifyCallback);
        req.setVer("V1");
        return req;
    }

    public Long getRefundSerialNo() {
        return System.currentTimeMillis() + (int) (Math.random() * 9000) + 1000;
    }

}
