/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StockClient
 * @Package cn.freemud.service.thirdparty
 * @Description: 1.5.4对接库存服务
 * @author: ping.wu
 * @date: 2019/2/20 14:42
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.aop.IgnoreFeignLogAnnotation;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.GetProductStockRequestDto;
import cn.freemud.entities.dto.GetProductStockResponseDto;
import cn.freemud.entities.dto.UpdateProductStockRequestDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "ims-service",url = "${saas.productstockclient.feign.url}")
@RequestMapping(value = "/inv",produces = {"application/json;charset=UTF-8"})
public interface StockClient {

    /**
     * 前端查询多个商品库存信息
     */
    @PostMapping("/getAvailableStocks")
    @IgnoreFeignLogAnnotation(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.CODE,messageFieldName=ResponseCodeKeyConstant.MESSAGE)
    GetProductStockResponseDto getAvailableStocks(@RequestBody GetProductStockRequestDto requestDto);

    /**
     * 修改库存接口，根据changeType字段区分使用，1增加库存，2减少库存，3修改库存
     * @param requestDto
     * @return
     */
    @PostMapping("/updateStocks")
    BaseResponse updateStocks(@RequestBody UpdateProductStockRequestDto requestDto);
}
