package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;
import java.util.Objects;

@Data
public class ActivityCalculationDiscountRequestDto {
    /**
     * 区域
     */
    private String area;
    /**
     * 可用渠道
     */
    private String channel;
    /**
     * 绑定的小程序id
     */
    private String appId;
    /**
     * i应用传isaas，快中台传fast
     */
    private String application = "isaas";
    /**
     * 是否展示活动列表 0：默认，不展示  1：展示
     */
    private Integer isShowActivities;
    /**
     * 是否显示商品的活动信息 0：默认，不展示  1：展示
     */
    private Integer isShowGoodsActivity;
    /**
     * 商户
     */
    private String partnerCode;
    /**
     * 门店
     */
    private String storeId;

    /**
     * 门店的组织机构树
     */
    private List<String> orgIds;

    /**
     * 用户id（有优惠券时，该字段必传）
     */
    private String userId;
    /**
     * 版本号
     */
    private Integer ver;
    /**
     * 优惠券集合
     */
    private List<CalculationDiscountCoupon> coupons;
    /**
     * 商品集合
     */
    private List<CalculationDiscountGoods> goods;

    private Long distributionFee;

    @Data
    public static class CalculationDiscountCoupon {
        /**
         * 优惠券码
         */
        private String code;
        /**
         * 活动号
         */
        private String activityCode;
    }

    @Data
    public static class CalculationDiscountGoods {
        /**
         * 商品ID
         */
        private String goodsId;
        /**
         * 商品品类
         */
        private String category;
        /**
         * 商品数量
         */
        private Integer goodsQuantity;
        /**
         * 原价（分）
         */
        private Long originalPrice;

        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
                return false;
            CalculationDiscountGoods that = (CalculationDiscountGoods) o;
            return Objects.equals(goodsId, that.goodsId) &&
                    Objects.equals(category, that.category) &&
                    Objects.equals(originalPrice, that.originalPrice);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), goodsId, category, originalPrice);
        }
    }
}
