package cn.freemud.management.entities.dto.response.order;

import cn.freemud.management.enums.OrderStatus;
import cn.freemud.management.enums.RefundStatus;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.Size;

@Data
public class OrderManagerResponse {
    /**
     * 预订单打印时间{1：提醒时打印；2：接单时打印} 默认为1
     */
    private String orderPrintConfig;
    /**
     * 订单预约时间
     */
    private Long gmtExpect;
    /**
     * 订单状态
     * 1=下单，2=待支付，3=接单，4=配送中，5=完成，6=取消，7=拒单，31=制作完成
     * @see OrderStatus
     */
    private Integer status;
    /**
     * 订单退款状态
     * 1 申请退款 2 同意退款 3 已退货 4 退款完成 5 拒绝退款
     * @see RefundStatus
     */
    private Integer refundStatus;

    public OrderManagerResponse(){
    }

    public OrderManagerResponse(String orderPrintConfig, Long gmtExpect){
        this.orderPrintConfig=orderPrintConfig;
        this.gmtExpect=gmtExpect;
    }
    public OrderManagerResponse(RefundStatus refundStatus){
        if (refundStatus!=null){
            this.refundStatus=refundStatus.getCode();
        }
    }
    public OrderManagerResponse(OrderStatus status, RefundStatus refundStatus){
        if (status!=null){
            this.status=status.getCode();
        }
        if (refundStatus!=null){
            this.refundStatus=refundStatus.getCode();
        }
    }

    public OrderManagerResponse(Long gmtExpect, Integer status, Integer refundStatus) {
        this.gmtExpect=gmtExpect;
        this.status = status;
        this.refundStatus = refundStatus;
    }
    public OrderManagerResponse(String orderPrintConfig, Long gmtExpect, RefundStatus refundStatus){
        this.orderPrintConfig=orderPrintConfig;
        this.gmtExpect=gmtExpect;
        if (refundStatus!=null){
            this.refundStatus=refundStatus.getCode();
        }
    }
}
