/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: QueryOrderResponseVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/23 14:21
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo.encircle;

import cn.freemud.entities.dto.PromotionMessageDto;
import cn.freemud.entities.dto.shoppingCart.ActivityDiscountsDto;
import cn.freemud.entities.vo.*;
import lombok.Builder;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class PreviewOrderInfoVo {

    private String oid;

    /**
     * 桌号
     */
    private String tableNumber;

    /**
     * 支付许可状态 1.可支付  0.不可唤起支付
     */
    private Integer payLicenceStatus;
    /**
     * 订单金额
     */
    private Long amount;
    /**
     * 商品总金额 不包括满减，配送费，包装费
     */
    private Long itemAmount;
    /**
     * 优惠总金额
     */
    private Long discountTotalAmount;
    /**
     * 退款状态  enum  refundStatus
     */
    private Integer refundStatus;

    /**
     * 订单状态   enum  OrderStatus ,DeliverStatus=42 骑手取餐中
     */
    private Integer orderStatus;
    /**
     * 订单状态描述
     */
    private String orderStatusDesc;

    /**
     * 支付状态  enum  PayStatus
     */
    private Integer payStatus;
    /**
     * 支付状态描述
     */
    private String payStatusDesc;

    /**
     * 订单修改版本号
     */
    private Integer orderUpdateVer;

    private List<ProductVo> products;

    /**
     * 门店名称
     */
    private String shopName;

    private List<PromotionMessageDto> promotionMessages;

    /**
     * 商品数量
     */
    private Integer productNum;
    /**
     * 可用优惠券列表
     */
    private ActivityClassifyCouponBean availableCoupon;
    /**
     * 满减折扣
     */
    private Long fullDiscount;
    /**
     * 优惠券折扣
     */
    private Long couponDiscount;
    /**
     * 前端用来提示的信息
     */
    private String toastMsg;
    /**
     * 活动信息
     */
    private ActivityTip activityTip;

}
