package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.BaseResponseDto;
import cn.freemud.entities.dto.MCCafeDeliveryBaseResponse;
import cn.freemud.entities.dto.delivery.*;
import cn.freemud.entities.dto.delivery.QueryDeliveryAmountRequestDto;
import cn.freemud.entities.dto.delivery.QueryDeliveryAmountResponseDto;
import cn.freemud.entities.vo.CreateDeliveryVo;
import com.freemud.application.sdk.api.deliverycenter.response.CreateDeliveryOrderResponseDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = "DELIVERYCENTER", url = "${delivery.center.baseUrl}")
public interface DeliveryFeiginClient {

    @PostMapping("/deliveryLogisticsAmount/queryDeliveryAmount")
    QueryDeliveryAmountResponseDto queryDeliveryAmount(@RequestBody QueryDeliveryAmountRequestDto request);

    @PostMapping("/delivery/orderRemind")
    QueryDeliveryAmountResponseDto orderRemind(@RequestBody OrderRemindRequestDto request);

    @PostMapping("/delivery/listFreeRider")
    MCCafeDeliveryBaseResponse<ResRiderTrackDto> listFreeRider(@RequestBody QueryLocusRiderTrackDto request);

    @PostMapping("/delivery/create")
    CreateDeliveryOrderResponseDto deliveryOrderAdd(@RequestBody CreateDeliveryVo request);

    @PostMapping("/delivery/getDeliveryStatusAndRiderPosition")
    DeliveryBaseResponse<DeliveryStatusAndRiderPositionDto> queryDeliveryStatusAndRiderPosition(@RequestBody QueryDeliveryBaseRequest queryDeliveryBaseRequest);

}
