package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.AppCreateOrderVo;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.CreatePrepayVo;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import cn.freemud.entities.dto.ConfirmOrderDto;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.entities.vo.PaysuccessNoticeMessage;

import java.util.Map;

/**
 * app订单服务
 */
public interface AppOrderService {

    /**
     * 创建订单
     */
    BaseResponse createOrderFlow(CreateOrderVo createOrderVo);

    /**
     * 创建预支付
     */
    BaseResponse createPrepay(CreatePrepayVo createPrepayVo);

    /**
     * APP下单，下单带商品信息，不经过购物车服务，不唤起支付
     */
    BaseResponse createOrder(AppCreateOrderVo createOrderVo, AssortmentCustomerInfoVo customerInfo);
    /**
     * 支付回调
     */
    String paySuccessCallback(PaysuccessNoticeMessage message, ConfirmOrderDto confirmOrderDto, Map<String, QueryOrdersResponseDto.DataBean.OrderBean> orderBeans);
}
