package cn.freemud.entities.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
public class PushMessageNoticeDto {


    /**
     * 版本号  默认1
     */
    private String ver;
    /**
     * 商户ID
     */
    private String partnerId;
    /**
     * 门店ID
     */
    private String storeId;
    /**
     * 推送目标 1 小程序 2 pos机
     */
    private Integer targetType;
    /**
     * 推送目标 ID targetId
     */
    private String targetId;

    private Integer cmd;

    private String data;

    /**
     * "ttl":30 过期时间（秒）
     */
    private Integer ttl;

    @Data
    @NoArgsConstructor
    public static class Message {
        /**
         * 1 表示新订单接单
         */
        private Integer type;

        private cn.freemud.entities.dto.PushMessageNoticeDto.Message.Content content;

        @Data
        @NoArgsConstructor
        public static class Content {

            @JsonProperty("take_code")
            private String take_code;

            private String queueIndex;
            /**
             * 订单号
             */
            private String oid;
            /**
             * 订单状态
             */
            private Integer deliveryStatus;
            /**
             * 下单appid
             */
            private String fromAppId;
            /**
             * 取餐号
             */
            private String pickUpGoodsNo;
            /**
             * 用户id
             */
            private String userId;
            /**
             * 订单状态
             */
            private Integer orderState;
            /**
             * 订单渠道
             */
            private Integer orderClient;
            /**
             * 异常信息
             */
            private String errorMsg;


        }
    }

}
