package cn.freemud.entities.vo.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

@Data
public class PaymentConfigVo {

    @ApiModelProperty("会话Id")
    @NotEmpty(message = "会话Id不能为空")
    private String sessionId;

    @ApiModelProperty("商户号")
    @NotEmpty(message = "商户号不能为空")
    private String partnerId;

    @ApiModelProperty("门店号")
    private String shopId;

    /**
     * 插件类型 1=爱心餐　2= 周周惠
     */
    @ApiModelProperty("插件类型 1=爱心餐 2= 周周惠")
    private Integer plugInType;

}
