/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CreateOrderProductDto
 * @Package cn.freemud.entities.dto
 * @Description: 订单商品列表
 * @author: liming.guo
 * @date: 2018/5/18 16:56
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.vo.ProductGroupVo;
import lombok.Data;

import java.util.List;

@Data
public class CreateOrderProductRequest extends BaseConfig {
    /**
     * 商品
     */
    private String productId;
    /**
     * 商品名称
     */
    private String productName;

    /**商品英文名**/
    private String productForeignName;

    /**
     * 原有商品类型
     *
     * 溯源: 订单有自己的商品逻辑 无法使用原有字段类型记录处理
     * 该字段,保持和商品服务的商品类型一致
     */
    private Integer originalProductType;

    /**
     * 商品数量
     */
    private Integer number;
    /**
     * 商品规格
     */
    private String specification;
    /**
     * 商品规格名称
     */
    private String specificationName;

    /**
     * 商品规格英文名称
     */
    private String specificationForeignName;
    /**
     * 第三方商品编号，商品服务唯一
     */
    private String customerCode;
    /**
     * 商品货号，商品服务可重复
     */
    private String productCode;

    //多规格商品的spu商品　商品货号，单规格即为单规格商品货号
    private String spuProductCode;
    /**
     * 商品价格 单价分
     */
    private Long price;
    /**
     * 实际销售价
     */
    private Long salePrice;
    /**
     * 商品行优惠总金额=数量*单个商品优惠金额
     */
    private Long totalDiscountAmount;
    /**
     * 商品图片
     */
    private String picture;
    /**
     * 排序
     */
    private Integer sequence;
    /**
     * 商户序号
     */
    private Integer opid;
    /**
     * 属性 温|半糖|甜
     */
    private String addInfo;

    private String foreignAddInfo;
    /**
     * 属性
     */
    private String extras;
    private String foreignExtras;

    /**
     * 第三方菜品分类Id
     */
    private String thirdCategoryId;
    /**
     * 商品所属菜单分类id
     */
    private String categoryId;
    /**
     * 商品所属菜单分类名称
     */
    private String categoryName;

    /**
     * 设置为1标识1.5.2版本以后新订单，影响B端订单详情显示 1.5.2增加
     */
    private Integer ignoreProductPrice;

    /**
     * 是否是库存商品
     */
    private Boolean hasStockProudct;

    /**
     * 重量
     */
    private Double weight;

    private String discountId;

    /**
     * 父级商品编号
     */
    private String parentProductId;
    /**
     * 是否是套餐内固定商品
     */
    private Boolean isFixedProduct;

    private Long productGroupId;

    /**
     * 套餐--6
     */
    private Integer productType;

    private String unit;
    /**
     * 是否是称重菜
     */
    private boolean isWeighProduct = false;
    /**
     * 套餐固定商品
     */
    private List<CreateOrderProductRequest> comboProduct;
    /**
     *加料商品
     */
    private List<CreateOrderProductRequest> materialProduct;
    /**
     * 优惠列表
     */
    private List<CreateOrderAccountRequest> accounts;

    /**
     * 订单上商品明细id,由订单生成
     */
    private Long id;

    /**
     * 是否删除
     */
    private Boolean isDeleted;
    /**
     * 商品第三方规格编号
     */
    private String thirdProductSpecId;
    /**
     * 商品第三方属性编号
     */
    private String thirdProductPropertyId;

    /** 商品组 **/
    private List<ProductGroupVo> productGroupList;

    /** 是否主食**/
    private Integer stapleFood;

    /** 商品统计分类编号**/
    private String classificationId;

    private String classificationName;
    private String category;

    /** 商品税率**/
    private double tax;

    private String taxId;

    /**
     * 加购人ID
     */
    private String userId;

    /**
     * 加购人openId
     */
    private String openId;

    /**
     * 加购人昵称
     */
    private String nickName;

    /**
     * 加购人头像
     */
    private String photoUrl;

    /**
     * 加购人包装费
     */
    private Long packPrice;

    private List<OrderSpecialExtraAttrRequest> specialAttrs;

    /**
     * 购物车行uid
     */
    private String cartGoodsUid;

    /**
     * 拼单买一赠一标记赠品是那个商品送的 originalGoodsUid
     */
    private String originalGoodsUid;

    /**
     * 是否需要积分
     */
    private Boolean needBonus;
    /**
     * 拆分前所属序列
     */
    private String splitIndex;

    /**
     * 虚拟商品使用，发券id
     */
    private String cardId;

    /**
     * 虚拟商品使用，种子券号
     */
    private String cardCode;

    /**
     * 是否赠品
     */
    private Boolean isSendGoods;
    /**
     * 是否是月享卡商品
     */
    private int isMonthCard = 0;
    /**
     * 是否是买3赠1券商品
     */
    private int isB3S1Coupon = 0;

    //积分商品活动使用总积分
    private Long score;

    private String extInfo;

    /**
     *  【订C，“POS编码”让凌顶那边去匹配商品】 https://www.tapd.cn/43862731/prong/stories/view/1143862731001039549
     */
    private String linkedId;
}
