package cn.freemud.fuyou.feign.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * @author yuanyuan.jing 2018/12/18 19:00
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "付款码支付响应")
public class CodePayResponse extends BaseResult{

    @ApiModelProperty(value = "第三方支付交易序号",position = 8)
    private String payTransId;

    @ApiModelProperty(value = "非码交易流水号",position = 9)
    private String fmId;

    @ApiModelProperty(value = "支付渠道, 参考字典信息: https://cf.freemudvip.com/pages/viewpage.action?pageId=28051530", position = 10)
    private String payCode;

    @ApiModelProperty(value = "用户标识", position = 11)
    private String userId;

    @ApiModelProperty(value = "原始渠道: W 微信，A 支付宝", position = 12)
    private String originalChannel;

    @ApiModelProperty(value = "商家优惠金额")
    private Integer merchantCoupon;

    @ApiModelProperty(value = "平台优惠金额")
    private Integer platformCoupon;

    /**
     * 赋值 默认值0
     * @return
     */
    public Integer getMerchantCoupon() {
        return merchantCoupon != null ? merchantCoupon : 0;
    }

    /**
     * 赋值 默认值0
     * @return
     */
    public Integer getPlatformCoupon() {
        return platformCoupon != null ? platformCoupon : 0;
    }
}
