package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: QueryCartInfoRequestVo
 * @Package cn.freemud.entities.vo
 * @Description: 简单描述下这个类是做什么用的
 * @author: yu.sun
 * @date: 2020/9/11 10:35
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class QueryCartInfoRequestVo {
    @ApiModelProperty(value = "用户Id",required = true)
    @NotEmpty(message = "用户Id不可为空")
    private String userId;
    @ApiModelProperty(value = "商户Id",required = true)
    @NotEmpty(message = "商户Id不可为空")
    private String partnerId;
    @ApiModelProperty(value = "门店id",required = true)
    @NotEmpty(message = "门店id不可为空")
    private String storeId;
    @ApiModelProperty(value = "sessionId",required = true)
    @NotEmpty(message = "用户sessionId不可为空")
    private String sessionId;

    @ApiModelProperty(value = "appId",required = true)
    @NotEmpty(message = "appId不可为空")
    private String appId;
    @ApiModelProperty(value = "menuType",notes = "业务类型： 0 : 自提 1：外卖 2：微商城",required = true)
    @NotEmpty(message ="业务类型不可为空")
    private String menuType ;

    @ApiModelProperty(value = "订单类型")
    @NotNull(message = "订单类型不可为空")
    private Integer orderType;

    @ApiModelProperty(value = "收货地址id",notes = "svc卡支付外卖订单必传")
    private String receiveId;
}