package cn.freemud.entities.vo;

import cn.freemud.entities.dto.CreateOrderProductDto;
import cn.freemud.entities.dto.UserDeliveryInfoDto;
import cn.freemud.entities.dto.delivery.WeixinDeliveryAddressDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: AppCreateOrderVo
 * @Package cn.freemud.entities
 * @Description:
 * @author: ping1.wu
 * @date: 2020/4/23 16:39
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class AppCreateOrderVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    private String partnerId;

    //@NotEmpty(message = "门店ID 不能为空")  //本次需要根据业务做校验
    private String shopId;

    private String thirdShopId;

    /**
     * 订单类型  1 到店自取 2 外卖   枚举CreateOrderType
     */
    //@NotNull(message = "下单类型不能为空")
    private Integer orderType;

    /**
     * 到店类型  4(打包带走)和5（店内就餐）
     */
    private Integer reachStoreType;

    /**
     * 取餐时间
     */
    private String takeMealTime;
    /**
     * 订单备注
     */
    private String orderRemark;
    /**
     * 收货地址ID
     */
    private String receiveId;
    /**
     * 收货人性别 sexType 1 男 2 女 0 未知
     */
    private Integer sex;

    @Builder.Default
    private String menuType = "saas";

    @Valid
    private List<OrderProductVo> orderProducts;

    /**
     * 下单渠道 版本号
     */
    private String version;
}
