package cn.freemud.service.impl;

import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityDiscountsDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.enums.GoodsTypeEnum;
import cn.freemud.service.IPromotionService;
import com.google.common.collect.Lists;
import com.sun.tools.javac.comp.Check;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.service.impl MaterialPromotionImpl
 * @Description: TDO 描述....
 * @author: family
 * @date: 2020/7/29
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service("MaterialPromotionService")
public class MaterialPromotionService implements IPromotionService {

    /**
     * 总优惠和总原价促进已经计算过了，这里只需要累积行记录
     * 加料优惠金额
     *
     * @param couponPromotionVO
     * @param activityQueryDto
     * @param calculationDiscountResult
     * @param cartGoodsList
     * @param shoppingCartGoodsResponseVo
     * @param userLoginInfoDto
     * @param shoppingCartInfoRequestVo
     */
    @Override
    public void updateShoppingCartGoodsDiscount(CouponPromotionVO couponPromotionVO, ActivityQueryDto activityQueryDto, ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, List<CartGoods> cartGoodsList, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, UserLoginInfoDto userLoginInfoDto, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        HashMap<String, ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.Material> map = getApportionGoodsDetail(calculationDiscountResult);
        if (map != null && !map.isEmpty()) {
            for (CartGoods cartGoods : cartGoodsList) {
                if (cartGoods.getProductMaterialList().size() == 0) continue;
                for (CartGoods.MaterialGoods materialGoods : cartGoods.getProductMaterialList()) {
                    ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.Material material = map.get(materialGoods.getMaterialId());
                    //设置小料行单价和行总价
                    if (material.getNowPrice() > 0) {
                        materialGoods.setFinalPrice(material.getNowPrice());
                        materialGoods.setAmount(material.getNowPrice() * cartGoods.getQty());
                    }
                }
            }
        }
        long materialAmount = 0L;
        for (CartGoods cartGoods : cartGoodsList) {
            if (cartGoods.getProductMaterialList().size() == 0) continue;
            materialAmount = 0L;
            for (CartGoods.MaterialGoods materialGoods : cartGoods.getProductMaterialList()) {
                materialAmount += materialGoods.getFinalPrice() * cartGoods.getQty();
            }
            //设置商品行现总价 商品总价+小料商品总价
            cartGoods.setAmount(cartGoods.getAmount() + materialAmount);
        }
    }

    /**
     * 加料商品设置行均摊记录
     *
     * @param shoppingCartGoodsResponseVo
     * @param calculationDiscountResult
     * @param shoppingCartGoodsDto
     * @param premiumExchangeActivity
     * @param shoppingCartInfoRequestVo
     */
    @Override
    public void updateShoppingCartGoodsApportion(ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, ShoppingCartGoodsDto shoppingCartGoodsDto, CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        HashMap<String, ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.Material> map = getApportionGoodsDetail(calculationDiscountResult);
        if (map == null && map.isEmpty()) return;
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> products = shoppingCartGoodsDto.getProducts();
        for (ShoppingCartGoodsDto.CartGoodsDetailDto product : products) {
            if (product.getMaterialList().size() == 0) return;
            for (ShoppingCartGoodsDto.CartGoodsDetailDto.MaterialGoods materialGoods : product.getMaterialList()) {
                ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.Material material = map.get(materialGoods.getMaterialId());
                if (material.getApportionAmount().intValue() == 0) continue;

                //设置行记录参加的活动及总优惠
                ActivityDiscountsDto activityDiscountsDto = new ActivityDiscountsDto();
                List<ActivityDiscountsDto> activityDiscountsDtoList = new ArrayList<>();
                activityDiscountsDto.setActivityCode(material.getApportionDetails().get(0).getActivityCode());
                activityDiscountsDto.setActivityName(material.getApportionDetails().get(0).getActivityName());
                activityDiscountsDto.setActivityType(material.getApportionDetails().get(0).getActivityType());
                activityDiscountsDto.setDiscountAmount(material.getApportionDetails().get(0).getActivityApportionAmount().intValue());
                activityDiscountsDtoList.add(activityDiscountsDto);

                materialGoods.setActivityDiscountsDtos(activityDiscountsDtoList);
                materialGoods.setTotalDiscountAmount((materialGoods.getOriginalPrice().intValue() - materialGoods.getSalePrice().intValue()) * product.getQty());
                product.setProductType(GoodsTypeEnum.MATERIAL.getGoodsType());
            }
        }
    }

    /**
     * 提取促销均摊
     *
     * @param calculationDiscountResult
     * @return
     */
    private HashMap<String, ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.Material> getApportionGoodsDetail(ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult) {

        // 遍历促销
        if (calculationDiscountResult == null || CollectionUtils.isEmpty(calculationDiscountResult.getApportionGoods())) {
            return null;
        }
        HashMap<String, ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.Material> hashMap = new HashMap<>();
        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods apportionGood : calculationDiscountResult.getApportionGoods()) {
            if (CollectionUtils.isEmpty(apportionGood.getSmallMaterial())) continue;
            for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.Material material : apportionGood.getSmallMaterial()) {
                hashMap.put(material.getGoodsId(), material);
            }
        }
        return hashMap;
    }

}
