package cn.freemud.fuyou.feign.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 条码支付请求
 *
 * @author Tony
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "付款码支付请求")
public class CodePayReq extends BasicOfflineReq {


    //    @NotEmpty(message = "支付条码不能为空")
    @ApiModelProperty(value = "支付条码", position = 2)
    private String code;

    //    @NotEmpty(message = "订单描述不能为空")
    @ApiModelProperty(value = "订单描述")
    private String body;

    @ApiModelProperty(value = "支付商品信息")
    private List<Product> products;

    @ApiModelProperty(value="分账详情，json串，具体参照相关渠道文档" )
    private String divideDetail;

    @ApiModelProperty(value = "支付超时时间")
    private String payTimeOutTime;
}
