package cn.freemud.demo.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.entities.bo.goods.ShoppingCartGoodsBO;
import cn.freemud.demo.entities.bo.goods.*;
import cn.freemud.demo.entities.bo.goods.update.UpdateAddGoodsBO;

public interface UpdateGoodsQtyService {

    /**
     *
     * 检验客制化的参数
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse checkCustomParams(UpdateAddGoodsBO baseRequestDTO) {
        return ResponseBuilder.success();
    }


    /**
     * 获取购物车信息
     * @param baseRequestDTO
     * @return
     */
    default CheckBussinessRulesBO getShoppingCartInfo(UpdateAddGoodsBO baseRequestDTO) {
        return new CheckBussinessRulesBO();
    }

    /**
     * 进行客制化的业务校验
     * @param baseRequestDTO
     * @return
     */
    default AddGoodsToShoppingCartBO checkCustomBusinessRules(UpdateAddGoodsBO baseRequestDTO, CheckBussinessRulesBO checkBussinessRulesBO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO) {
        return addGoodsToShoppingCartBO;
    }



    /**
     * 购物车赋值
     * @param baseRequestDTO
     * @return
     */
    default DiscountResultBO customAddGoodsToShoppingCart(UpdateAddGoodsBO baseRequestDTO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO, DiscountResultBO customCalCostBO) {
        return customCalCostBO;
    }



    /**
     * 进行客制化的计算费用
     * @param baseRequestDTO
     * @return
     */
    default DistributeBO calCustomCost(UpdateAddGoodsBO baseRequestDTO, CalCostBO calCostBO, DistributeBO commonSetMessageBO) {
        return commonSetMessageBO;
    }

    default CalCostBO getDiscountResultBefore(UpdateAddGoodsBO baseRequestDTO, DiscountResultBO calCostBO) {
        return new CalCostBO();
    }

    /**
     * 客制化优惠计算
     * @param baseRequestDTO
     * @return
     */
    default CalCostBO getDiscountResultAfter(UpdateAddGoodsBO baseRequestDTO, DiscountResultBO calCostBO, CalCostBO commonSetMessageBO) {
        return commonSetMessageBO;
    }

    /**
     * 客制化优惠响应
     * @param baseRequestDTO
     * @return
     */
    default SetMessageBO customDistribute(UpdateAddGoodsBO baseRequestDTO, DistributeBO calCostBO, SetMessageBO commonSetMessageBO) {

        return commonSetMessageBO;
    }

    /**
     * 客制化信息提醒
     * @param baseRequestDTO
     * @return
     */
    default ShoppingCartGoodsBO setCustomMessage(UpdateAddGoodsBO baseRequestDTO, SetMessageBO setMessageBO, ShoppingCartGoodsBO shoppingCartGoodsBO) {
        return shoppingCartGoodsBO;
    }

}
