package cn.freemud.entities.dto.calculate;

import lombok.Data;

@Data
public class SendGoods {

    /**
     * 买一赠一时，存赠送主商品的cartGoodsUid 用于标记是那个商品送的
     */
    private String originalGoodsUid;

    /**
     * 赠送商品ID
     */
    private String goodsId;
    /**
     * 品类
     */
    private String category;
    /**
     * 赠送商品名称
     */
    private String goodsName;
    /**
     * 赠送商品现价（单位：分）（加价换购时表示需要加的价格）
     */
    private Long nowPrice;
    /**
     * 赠送商品原价
     */
    private Long originalPrice;
    /**
     * 赠送商品数量
     */
    private Integer sendNumber;

    /**
     *  可兑换商品券编号
     */
    private String sendCouponCode;

    /**
     *  可兑换商品券名称
     */
    private String sendCouponName;

    /**
     *  是否已选择寄杯
     */
    private Boolean sendCoupon;

    private String picture;

    /**
     * 商品类型：2、是加料商品，9、是虚拟商品，7、是套餐商品，1、是单品
     */
    private Integer productType;

}
