package cn.freemud.entities.dto.calculate;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Objects;

@Data
public class ActivityCalculationDiscountRequestDto {
    /**
     * 区域
     */
    private String area;
    /**
     * 可用渠道
     */
    private String channel;
    /**
     * 绑定的小程序id
     */
    private String appId;
    /**
     * i应用传isaas，快中台传fast
     */
    private String application = "isaas";
    /**
     * 渠道
     */
    private String productChannel;
    /**
     * 是否展示活动列表 0：默认，不展示  1：展示
     */
    private Integer isShowActivities;
    /**
     * 是否显示商品的活动信息 0：默认，不展示  1：展示
     */
    private Integer isShowGoodsActivity;
    /**
     * 商户
     */
    private String partnerCode;
    /**
     * 门店
     */
    private String storeId;

    /**
     * 门店的组织机构树
     */
    private List<String> orgIds;

    /**
     * 用户id（有优惠券时，该字段必传）
     */
    private String userId;
    /**
     * 版本号
     */
    private Integer ver;
    /**
     * 优惠券集合
     */
    private List<CalculationDiscountCoupon> coupons;
    /**
     * 商品集合
     */
    private List<CalculationDiscountGoods> goods;

    /**
     * 已选换购活动集合
     */
    private List<CalculationActivityReqVO> selectActivityList;


    private Long distributionFee;

    /**
     * 购买月卡费用(分)
     */
    private Long payCardFee;
    /**
     * 是否是会员
     */
    private Boolean isMember;

    //当前请求是否自动勾选优惠券
    private Boolean autoCoupon;

    @Data
    public static class CalculationDiscountCoupon {
        /**
         * 优惠券码
         */
        private String code;
        /**
         * 活动号
         */
        private String activityCode;

        /**
         * 下标
         */
        private Integer useIndex;

        /**
         * 优惠券类型
         */
        private Integer couponType;

        /**
         * 购物车商品行uid（种子券商品才传）
         */
        private String cartGoodsUid;
    }

    @Data
    public static class CalculationDiscountGoods {
        /**
         * 键位编号（麦咖啡）
         */
        private String goodsCode;
        /**
         * 商品ID
         */
        private String goodsId;
        /**
         * 购物车行uid
         */
        private String cartGoodsUid;
        /**
         * 商品品类
         */
        private String category;
        /**
         * 商品数量
         */
        private Integer goodsQuantity;
        /**
         * 原价（分）
         */
        private Long originalPrice;
        /**
         * 加车时间
         */
        private Long addCartTime;
        /**
         * 折扣比例
         * 例如8折为80
         */
        private Integer memberDiscount;
        private String couponCode;
        /**
         * 加料
         */
        private List<Material> smallMaterial;
        private String spuId;

        /**
         * 套餐固定商品组
         */
        private List<GroupCombox> groupCombox;
        /**
         * 是否计算套餐
         */
        private boolean meal = false;

        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
                return false;
            CalculationDiscountGoods that = (CalculationDiscountGoods) o;
            return Objects.equals(goodsId, that.goodsId) &&
                    Objects.equals(category, that.category) &&
                    Objects.equals(cartGoodsUid, that.cartGoodsUid) &&
                    Objects.equals(originalPrice, that.originalPrice);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), goodsId, category, originalPrice);
        }

        @Data
        @NoArgsConstructor
        /**
         * 商品小料
         */
        static public class Material {
            /**
             * 加料商品ID
             */
            private String goodsId;
            /**
             * 加料数量
             */
            private Integer goodsQuantity;
            /**
             * 加料单价
             */
            private Long originalPrice;

            /**
             * 加料现价
             */
            private Integer nowPrice;
            /**
             * 1 :小料、2：可选搭配
             */
            private int type;
        }

        /**
         * 套餐固定商品组
         */
        @Data
        @NoArgsConstructor
        static public class GroupCombox {
            /**
             * 商品Id
             */
            private String goodsId;
            /**
             * 商品数量
             */
            private Integer goodsQuantity;
            /**
             * 商品原价
             */
            private Integer originalPrice;
        }
    }

    @Data
    @NoArgsConstructor
    public static class CalculationActivityReqVO {
        private String activityCode;
        private Integer activityType = 81;
        private List<CalculationSendGoodsReqVO> sendGoods;
    }

    @Data
    @NoArgsConstructor
    public static class CalculationSendGoodsReqVO {
        private String goodsId;
        private Integer goodsQuantity;
        private Integer originalPrice;
        private Integer nowPrice;

    }
}