package com.freemud.application.sdk.api.ordercenter.enums.orderv1;

public enum  OrderTypeV1 {

    TAKE_OUT(1, "外卖"),
    PRE_ORDER(2, "预订单"),
    MALL(3, "商城"),
    COLLECT_GOODS(4, "打包带走"),
    EAT_IN(5, "店内就餐")
            ;

    private Integer index;
    private String name;

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    OrderTypeV1() {
    }

    OrderTypeV1(Integer index, String name) {
        this.index = index;
        this.name = name;
    }

    public static OrderTypeV1 getOrderType(Integer type){
        for (OrderTypeV1 orderType : values()){
            if (type.equals(orderType.index)){
                return orderType;
            }
        }
        return null;
    }

}
