package com.freemud.application.sdk.api.ordercenter.service;

import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.ordercenter.OrderCenterApplication;
import com.freemud.application.sdk.api.ordercenter.enums.NewOrderStatus;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.enums.OrderType;
import com.freemud.application.sdk.api.ordercenter.request.*;
import com.freemud.application.sdk.api.ordercenter.request.create.BatchQueryByCodesReq;
import com.freemud.application.sdk.api.ordercenter.request.create.CreateOrderRequest;
import com.freemud.application.sdk.api.ordercenter.request.create.DeliveryContactInfoCreateReq;
import com.freemud.application.sdk.api.ordercenter.request.create.OrderItemCreateReq;
import com.freemud.application.sdk.api.ordercenter.response.*;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.QueryByCodeResponse;
import com.google.gson.Gson;
import org.assertj.core.util.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/1/6 13:55
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

@RunWith(SpringRunner.class)
@SpringBootTest(classes = OrderCenterApplication.class)
public class TestApiService {

    @Autowired
    private OrderSdkService orderSdkService;


    Gson gson = new Gson();

    @Test
    public void testCreateOrder() {

        CreateOrderRequest request = new CreateOrderRequest();
        request.setSettlementAmount(1100L);
        request.setPartnerId("1864");
        request.setPayType(1);
        request.setUserId("115541207106021389");
        request.setUserName("勤劳的小刷个040814");
        request.setStoreId("006");
        request.setStoreName("沃尔玛店");
        request.setOrderClient(2);
        request.setOrderType(3);
        request.setBizType(1);

        List<OrderItemCreateReq> orderItemList = new ArrayList<>();
        OrderItemCreateReq orderItemCreateReq = new OrderItemCreateReq();
        orderItemCreateReq.setPartnerId("1864");
        orderItemCreateReq.setProductName("红豆奶茶");
        orderItemCreateReq.setProductId("136574069314360347");
        orderItemCreateReq.setProductSpec("136574069322748935");
        orderItemCreateReq.setProductSpecName("红豆奶茶/标杯/常规");
        orderItemCreateReq.setProductSeq(1);
        orderItemCreateReq.setProductQuantity(1);
        orderItemCreateReq.setProductPrice(1100L);
        orderItemCreateReq.setSalePrice(1100L);
        orderItemCreateReq.setProductProperty("热/全糖");
        orderItemCreateReq.setProductPicUrl("https://picture.sandload.cn/1553044242475.jpg");
        orderItemCreateReq.setThirdProductId("123456");

        orderItemList.add(orderItemCreateReq);
        request.setOrderItemList(orderItemList);


        List<DeliveryContactInfoCreateReq> deliveryContactInfoList = new ArrayList<>();
        DeliveryContactInfoCreateReq deliveryContactInfoCreateReq = new DeliveryContactInfoCreateReq();
        deliveryContactInfoCreateReq.setRelateObjectType(1);
        deliveryContactInfoCreateReq.setInfoType(1);
        deliveryContactInfoCreateReq.setContactsName("勤劳的小刷个040814");
        deliveryContactInfoCreateReq.setMobile("13817429470");
        deliveryContactInfoCreateReq.setLatitude(null);
        deliveryContactInfoCreateReq.setLongitude(null);
        deliveryContactInfoCreateReq.setAddressDetail("");

        deliveryContactInfoList.add(deliveryContactInfoCreateReq);
        request.setDeliveryContactInfoList(deliveryContactInfoList);
        request.setNote("尽快送");


        String trackingNo = "";

        System.out.println(JSON.toJSONString(request));
        BaseResponse response = orderSdkService.createOrder(request, trackingNo);
        System.out.println(JSON.toJSONString(response));
    }

    @Test
    public void testGetOrderInfo() {
        //140656499831798138
        String trackingNo = "143025090022495749";
        //BaseResponse response = orderSdkService.getOrderInfo(trackingNo,0, trackingNo);

        // System.out.println("response:____________"+JSON.toJSONString(response));

    }


    @Test
    public void getOrderInfo() {
        QueryByCodeResponse queryByCodeResponse = orderSdkService.getOrderInfo("14855660231054721800036", 0, "");
        System.out.print(666);
    }


    @Test
    public void updateOrderState() {
        OrderChangeStateReq orderChangeStateReq = new OrderChangeStateReq();
        orderChangeStateReq.setOrderCode("14493162359333227200085");
        orderChangeStateReq.setOrderState(NewOrderStatus.COMPLETE.getIndex());
        orderChangeStateReq.setRemark("121231");
        BaseResponse baseResponse = orderSdkService.updateOrderState(orderChangeStateReq, "");
        System.out.println(JSON.toJSONString(baseResponse));
    }


    @Test
    public void testEditOrderInfo() {

        String trackingNo = "14120315097783451000089";
        UpdateOrderReq request = new UpdateOrderReq();
        request.setOrderCode(trackingNo);

        OrderExtInfoDto extInfoDto = new OrderExtInfoDto();
        extInfoDto.setPayTransId("wx27201153058749ab8fd685321633408074");
        extInfoDto.setAppid("wxb78fb7c6218cb52c");
        extInfoDto.setAccessToken("19_O7IA0OoFk7OS_-HQAA9_HvTyKp0GMz8FC9Wz89wJKxB44wWDvwSXbjbrmlt4kS6_x1c62A4mfsJgmy7KisMawSfAS7dcL-TnWVI1l3CB3aU_zinq3GMUd0NL-I-kwRQZWYbH2zkj65mqQltuVGRdAMDDOZ");
        extInfoDto.setExpireDate("");
        extInfoDto.setOpenid("oORZK5LWqxGZ2DKU2J9J-20y6MSo");
        extInfoDto.setPushOrderTime(0);
        extInfoDto.setSessionId("4e28a80d9297cc4a16cad935b0b2150020e4f176");
        extInfoDto.setServiceTime(20);
        request.setExtInfo(gson.toJson(extInfoDto));
        request.setOrderClient(2);
        System.out.println(gson.toJson(request));
        BaseResponse response = orderSdkService.editOrder(request, trackingNo);
        System.out.println("response:____________" + JSON.toJSONString(response));
    }

    @Test
    public void testPaySuccess() {
        String trackingNo = "14120315097783451000089";
        PaySuccessReq request = new PaySuccessReq();
        request.setOrderCode(trackingNo);
        request.setPayRequestNo("ZHL1407O1555313102");

        BaseResponse response = orderSdkService.paySuccess(request, trackingNo);

        System.out.println("response:____________" + JSON.toJSONString(response));

    }

    @Test
    public void testQueryOrderForUser() {
        String trackingNo = "14120315097783451000089";
        //{"endTimestamp":1556035199,"orderClients":[2],"orderStatus":[2,3,5,4],"orderType":[],"pageNum":1,"pageSize":10,"partnerId":"2282",
        // "startTimestamp":1553270400,"userId":"115560042247664714"}
        OrderUserConditionsReq request = new OrderUserConditionsReq();
        request.setEndTimestamp(1556035199L);
        List<Integer> orderClients = new ArrayList<>();
        orderClients.add(2);
        request.setOrderClients(orderClients);
        List<Integer> orderStatus = new ArrayList<>();
        orderStatus.add(2);
        orderStatus.add(3);
        orderStatus.add(4);
        orderStatus.add(5);
        request.setOrderStatus(orderStatus);
        request.setPageNum(1);
        request.setPageSize(10);
        request.setPartnerId("2282");
        request.setStartTimestamp(1553270400L);
        request.setUserId("115560042247664714");

        BaseResponse response = orderSdkService.queryOrderForUser(request, trackingNo);

        System.out.println("response:____________" + JSON.toJSONString(response));

    }

    @Test
    public void testCancelOrder() {
        String trackingNo = "14120315097783451000089";
        OrderCancelReq request = new OrderCancelReq();
        request.setPartnerId("1864");
        request.setOrderCode(trackingNo);
        request.setAfterSalesType(1);
        request.setOrderClient(2);
        request.setCancelReason("申请退款");
        //直接取消
        request.setCreateEvent(4);
        System.out.println(gson.toJson(request));

        BaseResponse response = orderSdkService.cancelOrder(request, trackingNo);

        System.out.println("response:____________" + JSON.toJSONString(response));

    }

    @Test
    public void testDeleteOrder() {
        String trackingNo = "14120315097783451000089";
        OrderDeleteReq request = new OrderDeleteReq();
        request.setOrderCode(trackingNo);

        BaseResponse response = orderSdkService.deleteOrder(request, trackingNo);

        System.out.println("response:____________" + JSON.toJSONString(response));

    }

    @Test
    public void testCreateAfterSalesOrder() {
        String trackingNo = "14075559248033412400089";
        CreateAfterSalesOrder request = new CreateAfterSalesOrder();
        request.setPartnerId("1864");
        request.setOrderCode("14438309262427033700089");
        request.setOrderClient(2);
        request.setActualAmount(null);
        request.setReqAmount(null);
        request.setAfterSalesType(2);
        request.setHasCargo(false);
        request.setCancelReason("不想要了");
        request.setReqRemark("临时有事变动");


        BaseResponse response = orderSdkService.createAfterSalesOrder(request, trackingNo);

        System.out.println("response:____________" + JSON.toJSONString(response));

    }


    //接单
    @Test
    public void testAcceptOrder() {
        String trackingNo = "14119309166619194800089";
        POSOrderOperationBaseReq request = new POSOrderOperationBaseReq();
        request.setOrderCode("14119309166619194800089");

        BaseResponse response = orderSdkService.acceptOrder(request, trackingNo);

        System.out.println("response:____________" + JSON.toJSONString(response));

    }

    //制作完成
    @Test
    public void testPrepareComplete() {
        String trackingNo = "14119063659850291700089";
        POSOrderOperationBaseReq request = new POSOrderOperationBaseReq();
        request.setOrderCode("14119063659850291700089");

        BaseResponse response = orderSdkService.prepareComplete(request, trackingNo);

        System.out.println("response:____________" + JSON.toJSONString(response));

    }

    //无配送完成
    @Test
    public void testCompleteDelivery() {
        String trackingNo = "14119063659850291700089";
        POSOrderOperationBaseReq request = new POSOrderOperationBaseReq();
        request.setOrderCode("14119063659850291700089");

        BaseResponse response = orderSdkService.completeDelivery(request, trackingNo);

        System.out.println("response:____________" + JSON.toJSONString(response));

    }

    //接单直接发货
    @Test
    public void testDirectDelivery() {
        String trackingNo = "14119309166619194800089";
        POSOrderOperationBaseReq request = new POSOrderOperationBaseReq();
        request.setOrderCode("14119309166619194800089");

        BaseResponse response = orderSdkService.directDelivery(request, trackingNo);

        System.out.println("response:____________" + JSON.toJSONString(response));

    }

    //已配送完成
    @Test
    public void testPrepareCompleteDelivery() {
        String trackingNo = "14119309166619194800089";
        POSOrderOperationBaseReq request = new POSOrderOperationBaseReq();
        request.setOrderCode("14119309166619194800089");

        BaseResponse response = orderSdkService.prepareCompleteDelivery(request, trackingNo);

        System.out.println("response:____________" + JSON.toJSONString(response));

    }

    @Test
    public void orderDownload() {
        OrderConditionsReq request = new OrderConditionsReq();
        request.setPartnerId("1864");
        request.setEndTimestamp(1555689600L);
        request.setPageSize(1);
        request.setPageSize(1000);
        request.setStartTimestamp(1555171200l);
        List<Integer> orderType = Lists.newArrayList();
        orderType.add(OrderType.GENERAL_DINE_IN.getIndex());
        orderType.add(OrderType.RESERVED_DINE_IN.getIndex());
        request.setOrderTypes(orderType);
        List<Integer> orderClientType = Lists.newArrayList();
        orderClientType.add(OrderClientType.SAAS.getIndex());
        request.setOrderClients(orderClientType);
        QueryOrderByConditionsResonse response = orderSdkService.orderDownload(request, "");
        System.out.println(JSON.toJSONString(response));
    }


    @Test
    public void queryOrderByDiscountTest() {
        String trackingNo = "123456";
        OrderDiscountReq request = new OrderDiscountReq();
        request.setPartnerId("1864");
        List<String> externalObjectIds = new ArrayList<>();
        externalObjectIds.add("123");
        request.setExternalObjectIds(externalObjectIds);

        List<Integer> settlementTypes = new ArrayList<>();
        settlementTypes.add(118);
        request.setSettlementTypes(settlementTypes);

        request.setStartTime("2019-04-01 13:05:52");
        request.setStartTime("2019-04-30 13:05:52");

        request.setPageSize(10);
        request.setPageNum(1);

        orderSdkService.queryOrderByDiscount(request, trackingNo);
    }

    @Test
    public void queryAfterSalesListTest() {
        OrderRefundQueryReq request = new OrderRefundQueryReq();
        request.setAfterCreateTimeEnd("2019-05-14 00:00:00");
        request.setAfterCreateTimeStart("2019-05-13 00:00:00");
//        request.setAfterSalesCode("");
        List<Integer> afterSalesStatusList = new ArrayList<>();
        afterSalesStatusList.add(1);
        request.setAfterSalesStatusList(afterSalesStatusList);
        List<Integer> afterSalesTypeList = new ArrayList<>();
        afterSalesTypeList.add(2);
        request.setAfterSalesTypeList(afterSalesTypeList);
        request.setCreateTimeEnd("2019-05-14 00:00:00");
        request.setCreateTimeStart("2019-05-13 00:00:00");
        request.setExpressType(2);
        request.setHasCargo(0);
        List<Integer> orderClientList = new ArrayList<>();
        orderClientList.add(2);
        request.setOrderClients(orderClientList);
        request.setOrderCode("14438309262427033700089");
        List<Integer> orderStateList = new ArrayList<>();
        orderClientList.add(2);
        request.setOrderStateList(orderStateList);
        request.setPageNum(1);
        request.setPageSize(10);
        request.setPartnerId("1864");
        request.setStoreId("006");
        List<String> toStoreIds = new ArrayList<>();
        toStoreIds.add("006");
        request.setToStoreIds(toStoreIds);
        request.setUserId("115541207106021389");
        request.setVer("1");

        BaseResponse<AfterSalesPageResp> response = orderSdkService.queryAfterSalesList(request, "");
        System.out.println(JSON.toJSONString(response));
    }

    @Test
    public void batchQueryTest() {
        // 其他参数正确，时间差为1分钟，订单服务返回状态码20003，初步判断只要查询不到订单，就不会返回正确响应
        BatchQueryReq request = new BatchQueryReq();
        request.setPartnerId("1864");
        request.setStoreId("1000189");
        request.setStartTimestamp(1558161214L);
        request.setEndTimestamp(1558161274L);
        request.setCount(10);

        BaseResponse<BatchQueryResp> response = orderSdkService.batchQuery(request, "");
        System.out.println(JSON.toJSONString(response));
    }

    @Test
    public void batchQueryByCodesTest() {
        List<String> orderCodes = new ArrayList<>();
        orderCodes.add("14501949096562925700083");
        orderCodes.add("14501949479712597900098");

        BatchQueryByCodesReq request = new BatchQueryByCodesReq();
        request.setOrderCodes(orderCodes);

        BaseResponse<List<OrderInfoReqs>> response = orderSdkService.batchQueryByCodes(request, null);
        System.out.println(JSON.toJSONString(response));
    }

    @Test
    public void getOrderInfoTest() {
        String orderClient = "11";
        String orderCode = null;
        String thirdOrderCode = "27003913648267755";
        QueryByCodeResponse response = orderSdkService.getOrderInfo(orderClient, orderCode, thirdOrderCode, 0, "");
        System.out.println(JSON.toJSONString(response));
    }

    @Test
    public void batchQueryAfterSalesTest() {
        List<Integer> afterSalesStatues = new ArrayList<>();
        afterSalesStatues.add(5);
        BatchQueryAfterSalesReq request = new BatchQueryAfterSalesReq();
        request.setPartnerId("1864");
        request.setStoreId("1000189");
        request.setCount(10);
        request.setStartTimestamp(1557555295000L);
        request.setEndTimestamp(1560233695768L);
        request.setAfterSalesStatues(afterSalesStatues);
        BaseResponse<BatchQueryAfterSalesResp> baseResponse = orderSdkService.batchQueryAfterSales(request, "");
        System.out.println(JSON.toJSONString(baseResponse));
    }
    @Test
    public void testUpdateThirdOrderCode(){
        SdkNewOrderUpdateThirdOrderCodeReq sdkNewOrderUpdateThirdOrderCodeReq=new SdkNewOrderUpdateThirdOrderCodeReq();
        sdkNewOrderUpdateThirdOrderCodeReq.setOrderCode("15036854468892109500090");
        sdkNewOrderUpdateThirdOrderCodeReq.setThirdOrderCode("323323323223");
        BaseResponse baseResponse=  orderSdkService.updateThirdOrderCode(sdkNewOrderUpdateThirdOrderCodeReq,"323323323223");
        Assert.assertEquals(baseResponse.getCode(),"100");
    }

    @Test
    public void testAffirmGroupOrder(){
        GroupOrderAffirmReq groupOrderAffirmReq = new GroupOrderAffirmReq();
        groupOrderAffirmReq.setOrderCode("15463125150495087500000");
        groupOrderAffirmReq.setPayType(2);
        BaseResponse baseResponse = orderSdkService.affirmGroupOrder(groupOrderAffirmReq,"2343243243");
        System.out.println("test affirm end:"+JSON.toJSONString(baseResponse));
    }

    @Test
    public void testCreateGroupOrder(){
        GroupCreateOrderRequest request = new GroupCreateOrderRequest();
        request.setPartnerId("1864");
        request.setStoreId("0011");
        request.setOrderClient(2);

        BaseResponse baseResponse = orderSdkService.createGroupOrder(request,"");
        System.out.println("test affirm end:"+JSON.toJSONString(baseResponse));
    }

    @Test
    public void testUpdateGroupOrder(){
        GroupOrderUpdateReq request = new GroupOrderUpdateReq();
        request.setOrderCode("15463125150495087500000");
        request.setDinersNumber(11);
        request.setNote("及哈哈哈哈");
        // BaseResponse baseResponse = orderSdkService.updateGroupOrder(request,"");
        //System.out.println("test affirm end:"+JSON.toJSONString(baseResponse));
    }

}
