package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

@Data
public class OrderAffirmRequestVO {
    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    /**
     * 商户ID
     */
    @NotEmpty(message = "商户号不能为空")
    private String partnerId;

    /**
     * 门店id
     */
    private String shopId;

    /**
     * 订单ID
     */
    @NotEmpty(message = "订单号不能为空")
    private String oid;

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;
}
