package cn.freemud.entities.db;

import cn.freemud.comm.entity.BaseEntity;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Data
@Table(name = "open_platform_wxapp")
public class OpenPlatformWxapp extends BaseEntity implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 小程序appid
     */
    private String appid;
    /**
     * 操作者id
     */
    private String  userid;

    /**
     *
     */
    private Integer status;
    /**
     * 微信appid
     */
    @Column(name = "wx_appid")
    private String wxAppid;

    /**
     * 绑定该小程序至开放平台的操作者
     */
    @Column(name = "bind_userid")
    private String bindUserid;
    /**
     * 开放平台appid
     */
    @Column(name = "open_appid")
    private String openAppid;

    /**
     * 小程序头像
     * 品牌ID
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 微信支付商户号
     */
    @Column(name = "mch_id")
    private String mchId;

    @Column(name = "nick_name")
    private String nickName;

    @Column(name = "head_img")
    private String headImg;

    @Column(name = "service_type_info")
    private Integer serviceTypeInfo;

    @Column(name = "verify_type_info")
    private Integer verifyTypeInfo;

    @Column(name = "user_name")
    private String userName;

    private String signature;

    @Column(name = "principal_name")
    private String principalName;

    @Column(name = "business_info")
    private String businessInfo;

    @Column(name = "qrcode_url")
    private String qrcodeUrl;

    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;
}