/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: MenuCategoryVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/15 14:40
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "SkuMenuCategoryVo 对象", description = "skuMenuCategoryVo")
public class SkuMenuCategoryVo {
    /**
     * 门店Id
     */
    private String shopId;

    /**
     * 菜单ID
     */
    @ApiModelProperty(value = "菜单ID", name = "menuId", example = "100001")
    private String menuId;
    /**
     * 分类名称
     */
    @ApiModelProperty(value = "分类名称", name = "categoryName", example = "奶茶")
    private String categoryName;
    /**
     * 节点ID
     */
    @ApiModelProperty(value = "节点ID", name = "nodeId", example = "1001")
    private String nodeId;
    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", name = "sequence", example = "0")
    private Integer sequence;

    /**
     * 商品信息
     */
    @ApiModelProperty(value = "商品信息", name = "products")
    List<SpuProductVo> products;
}
