/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderCallBackMQService
 * @Package cn.freemud.amp.service
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/16 14:29
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.amp.service;

import cn.freemud.amp.config.OrderCallBackConfig;
import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQAction;
import cn.freemud.amqp.MQMessage;
import cn.freemud.amqp.MQService;
import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.entities.dto.OrderExtInfoDto;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.WechatReportOrderDto;
import cn.freemud.entities.vo.OrderCallBackRequestVo;
import cn.freemud.redis.RedisCache;
import com.alibaba.fastjson.JSONObject;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformWxapp;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformWxappManager;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.enums.NewOrderStatus;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderItemResp;
import com.freemud.sdk.api.assortment.orderdistributor.request.DisRequest;
import com.freemud.sdk.api.assortment.orderdistributor.service.OrderDistributionService;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
public class OrderCallBackMQService {
    private static ApplicationContext context;

    @Autowired
    private MQService mqService;

    @Autowired
    private OrderDistributionService orderDistributionService;

    public void sendOrderMQ(OrderCallBackRequestVo body) {
        //发送订单回调
        Header header = new Header(MQAction.UPDATE.getAction(), "call-back-service-api",
                OrderCallBackConfig.QUEUE_ROUTING_KEY, OrderCallBackConfig.QUEUE_NAME);
        MQMessage<OrderCallBackRequestVo> message = new MQMessage<>(header, body);
        mqService.convertAndSend(OrderCallBackConfig.EXCHANGE_NAME, OrderCallBackConfig.QUEUE_ROUTING_KEY, message);
        //订单状态变更通知开放平台
        OrderInfoReqs orderInfoReqs = getOrderInfoReqs(body);
        if (orderInfoReqs != null) {
            orderDistributionService.pushOrder(convent2DisRequest(body, orderInfoReqs.getOrderState()));
        }
    }

    private DisRequest convent2DisRequest(OrderCallBackRequestVo orderBean, Integer orderState) {
        DisRequest disRequest = new DisRequest();
        disRequest.setExtJson(orderBean.getContent());
        disRequest.setStatus(orderState.toString());
        disRequest.setPartnerId(orderBean.getPartnerId());
        disRequest.setOrderCode(orderBean.getOrderCode());
        disRequest.setVer("2");
        disRequest.setOperateType(orderBean.getOperateType().toString());
        return disRequest;
    }

    private OrderInfoReqs getOrderInfoReqs(OrderCallBackRequestVo body) {
        // 订单所有状态正常变化通知通知开放平台
        if (!ObjectUtils.equals("1", body.getMsgType()) || body.getOperateType() == null || body.getOperateType() == 0) {
            return null;
        }
        OrderInfoReqs orderInfoReqs = null;
        try {
            orderInfoReqs = JSONObject.parseObject(body.getContent(), OrderInfoReqs.class);
        } catch (Exception ex) {
            ErrorLog.infoConvertJson(context.getEnvironment().getProperty("spring.application.name"), LogThreadLocal.getTrackingNo(), this.getClass(), "parseObjectOrderInfoReqsError", ex);
            return null;
        }
        return orderInfoReqs;
    }
}
