package cn.freemud.demo.entities.bo.goods;

import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import lombok.Data;

import java.util.List;

@Data
public class ProductBO {

    private String spuId;

    private String skuId;

    private String goodsId;

    private String nodeId;

    private Integer goodsType;

    private int type;

    private Integer stockLimit;

    private List<SkuProductBean> skuList;

    private Long packPrice;
    private String picture;
    private String unit;
    private Double weight;

    private Long finalPrice;
    private String name;
    private String customerCode;
    /**
     * 商品状态 入参不需要传，做对象组装使用 （/1下架/2上架/3售罄/4删除/5上架不可售(上架状态但是不在可售时间范围)）
     */
    private Integer status;

    /**
     * 数量
     */
    private Integer qty;
    private String category;
    /**
     * 分类名
     */
    private String categoryName;
    private Double tax;
    private String taxId;
    private String pid;
    private Long originalPrice;

    /**
     * 商品额外的属性
     */
    private List<CartGoodsExtra> extra;

    /**
     * 商品额外的属性
     */
    List<CartGoodsExtra>  specialExtra;;


    /**
     * 套餐固定商品
     */
    private List<ComboxGoodsBO> productComboList;
    /**
     * 套餐可选商品
     */
    private List<ComboxGoodsBO> productGroupList;

    /**
     * 加料
     */
    private List<MaterialBO> productMaterialList;

    @Data
    public static class SkuProductBean {
        private String skuId;
        private Integer stockLimit;
    }

}
