/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartRelationFactoryImpl
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.shoppingCart.impl;

import cn.freemud.service.shoppingCart.ShoppingCartRelationFactory;
import cn.freemud.service.shoppingCart.ShoppingCartRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ShoppingCartRelationFactoryImpl implements ShoppingCartRelationFactory {

    /**
     * coco商户
     */
    @Value("#{'${coco.partnerId}'.split(',')}")
    private List<String> cocoPartnerId;

    /**
     * coco
     */
    @Autowired
    @Qualifier("cocoShoppingCartRelationService")
    ShoppingCartRelationService cocoShoppingCartRelationService;

    /**
     * 平台
     */
    @Autowired
    @Qualifier("platformShoppingCartRelationService")
    ShoppingCartRelationService platformShoppingCartRelationService;

    @Override
    public ShoppingCartRelationService getBuildShoppingCartGoodsResponseService(String partnerId) {

        if(cocoPartnerId.contains(partnerId)){
            return cocoShoppingCartRelationService;
        }else{
            return platformShoppingCartRelationService;
        }
    }

}
