/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.entities.dto.UserDeliveryInfoDto;
import com.freemud.application.sdk.api.ordercenter.request.create.OrderPayItemCreateReq;
import io.swagger.annotations.ApiModel;
import com.freemud.application.sdk.api.ordercenter.request.create.OrderPayItemCreateReq;
import io.swagger.annotations.ApiModelProperty;
import cn.freemud.entities.dto.delivery.WeixinDeliveryAddressDto;
import lombok.Builder;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.ArrayList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


@Data
public class CreateOrderVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    //@NotEmpty(message = "门店ID 不能为空")  //本次需要根据业务做校验
    private String shopId;

    private String thirdShopId;

    /**
     * 就餐人数
     */
    private Integer peopleNumber;

    /**
     * 操作标识
     */
    private Integer operation;

    /**
     * 购物车版本号
     */
    private Integer carVer;

    /**
     * 下单版本号
     */
    private Integer orderUpdateVer;

    private String partnerId;

    private String storeName;

    //入参不需要传
    private String storeAddress;

    private String userId;


    private String userName;


    private String mobile;

    /**
     * 渠道 1 saas 2 img 爱马哥  默认saas 3. iwc i围餐
     */
    private String channel;
    /**
     * 订单类型  1 到店自取 2 外卖   枚举CreateOrderType
     */
    //@NotNull(message = "下单类型不能为空")
    private Integer orderType;

    /**
     * 订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单
     */
    private Byte marketingType;

    /**
     * 到店类型  orderType 传1的时候    如果reachStoreTyp为空转成订单类型4  如果不为空存储4(打包带走)和5（店内就餐）
     */
    private Integer reachStoreType;

    /**
     * 桌号
     */
    private String tableNumber;

    /**
     * 取餐时间
     */
    private String takeMealTime;

    /**
     * 预约时间 格式yyyy-MM-dd HH:mm:ss
     * 麦咖啡返回的是yyyy-MM-dd HH:mm
     */
    private String expectTime;

    /**
     * 取餐标识 0=我已到店、尽快送出 1预约单
     */
    private String takeMealFlag;
    /**
     * 是否外带 ,打包  1 是 0 否
     */
    private Integer takeOut;
    /**
     * 订单备注
     */
    private String orderRemark;
    /**
     * 收货地址ID
     */
    private String receiveId;
    /**
     * 收货办公楼
     */
    private String officeName;
    /**
     * 收货地址
     */
    private String receiveAddress;
    /**
     * 收货用户名
     */
    private String receiveUsername;
    /**
     * 收货电话
     */
    @Pattern(regexp = "^1[3|4|5|6|7|8|9][0-9]{9}$", message = "手机号码格式不正确")
    private String receiveMobile;
    /**
     * 收货人性别 sexType 1 男 2 女 0 未知
     */
    private Integer sex;
    /**
     * 用户定义纬度
     */
    private String latitude;
    /**
     * 用户定义经度
     */
    private String longitude;

    /**
     * 券码
     */
    private String couponCode;

    /**
     * 券码列表
     */
    private List<couponCode> couponCodes;

    /**
     * 运费券code
     */
    private String freightCouponCode;
    /**
     * 版本号
     */
    private String version;
    /**
     * form_id  用于金额是0的情况 现在只支持商品券,前端参数
     */
    private String formId;
    /**
     * 用户收货地址信息 ，入参不需要传,通过校验receiveId获取
     */
    public UserDeliveryInfoDto userDeliveryInfoDto;

    /**
     * 下单支付渠道类型
     */
    private Byte payChannelType;

    @Valid
    private PremiumExchangeActivity premiumExchangeActivity;

    /**
     * 买一赠一选择的商品
     */
    private List<ChooseGood> chooseGoods;

    /**
     * 是否使用用户积分
     * 1=不显示积分
     * 2=显示积分但不扣减
     * 3=显示积分且扣减
     */
    private Integer useCustomerScore;
    /**
     * 会员卡信息
     */
    private BuyMemberCard buyMemberCard;

    /**
     * svc 卡支付使用
     */
    private String cardCode;

    /**
     * 扫脸支付使用
     */
    private String faceCode;

    /**
     * 随单购啡常月享卡键位
     */
    private String cardKeyCode;

    /**
     * 随单购啡常月享卡键位
     */
    private String buyThreeGiveOneCardKeyCode;

    @ApiModelProperty(hidden = true)
    private String sessionKey; // 存储sessionKey,异常补退使用
    @ApiModelProperty(hidden = true)
    private String scene;// 打开小程序的场景值

    @Builder.Default
    private String menuType = "saas";
    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;

    /**
     * 是否需要餐具，1 需要 0不需要
     */
    private Integer needTableware;

    /**
     * 是否需要开发票，1 需要 0不需要
     */
    private Integer needInvoice;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 随单购是否购买月享卡
     * 1:不购买，2：月卡续费，3：新购月卡
     */
    private String buyMonthlyCard;

    private String monthlyCardCode;

    /**
     * 麦咖啡-买三赠一券活动号
     */
    private String buyThreeGiveOneActivityCode;

    /**
     * 麦咖啡-买三赠一券默认券号
     */
    private String buyThreeGiveOneCouponCode;

    private List<CouponType> couponTypeList;

    /**
     * 是否使用电子风味卡,如果不为空则为使用
     */
    @Valid
    @ApiModelProperty(value = "电子风味卡")
    private UnionPayCard unionPayCard;

    @Data
    public class CouponType {
        /**
         * 券类型 1：买三赠一券
         */
        private Integer type;
        /**
         * 券code
         */
        private String code;
    }
    /**
     * 电子风味卡
     */
    @Data
    @ApiModel(value = "电子风味卡", description = "如果传了电子风味卡字段,此类中属性必传")
    public static class UnionPayCard {

        @NotNull(message = "电子风味卡手机号必传")
        @ApiModelProperty(value = "电子风味卡卡号(手机号)",required = true)
        private String code;

        @NotNull(message = "电子风味卡密码必传")
        @ApiModelProperty(value = "电子风味卡密码",required = true)
        private String password;
    }

    /**
     * 微信配送地址信息
     */
    private WeixinDeliveryAddressDto weixinDeliveryAddress;

    @Data
    public static class PremiumExchangeActivity {
        @NotNull(message = "activityCode 不能为空")
        private String activityCode;
        @NotNull(message = "activityName 不能为空")
        private String activityName;
        /**
         * 加价购sku商品信息
         */
        @Valid
        private List<Product> products;

        @Data
        public static class Product {
            /**
             * spuId 商品原始id
             */
            @NotNull(message = "spuId不能为空")
            private String spuId;

            /**
             * skuId 如果是多规格 skuId 不能为空
             */
            @NotNull(message = "skuId不能为空")
            private String skuId;
            /**
             * 商品名称
             */
            @NotNull(message = "商品名称不能为空")
            private String skuName;

            @NotNull(message = "商品数量不能为空")
            private Integer qty;

            /**
             * 图片
             */
            private String picture;

            /**
             * 原价 入参不需要传，做对象组装使用
             */
            private Long originalPrice;
            /**
             * 现价 入参不需要传，做对象组装使用
             */
            private Long nowPrice;

            @Valid
            private List<Attribute> attributes;

            @Data
            public static class Attribute {
                /**
                 * 属性ID
                 */
                private String attributeId;

                /**
                 * 属性名称
                 */
                private String attributeValue;
            }
        }

    }

    @Data
    public final static class BuyMemberCard {
        /**
         * 付费会员卡ID
         */
        private String paidId;
        /**
         * 规则ID
         */
        private String ruleId;

    }

    @Data
    public static class ChooseGood {

        /**
         * 活动类型
         */
        private Integer activeType;

        /**
         * 活动号
         */
        private String activeCode;

        /**
         * 赠送商品id
         */
        private String goodsId;

        /**
         * 赠送商品名称
         */
        private String goodsName;

        /**
         * 赠送商品数量
         */
        private Integer qty;

        /**
         * 可兑换商品券编号
         */
        private String couponCode ;

        /**
         * 商品券兑换数量
         */
        private Integer couponQty;

        /**
         *  是否已选择寄杯
         */
        private Boolean sendCoupon;
    }

    @Data
    public final static class couponCode {
        /**
         * 优惠券
         */
        private String couponCode;
        /**
         * 活动号
         */
        private String activityCode;

        /**
         * 顺序
         */
        private Integer index;
    }
}
