/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartUpdateRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/22 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

@Builder
@Data
public class CollageOrderRequestVo {
    @ApiModelProperty(value = "当前登录人sessionId", required = true)
    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;

    @ApiModelProperty(value = "拼单创建人用户ID")
    private String createCollageUserId;

    @ApiModelProperty(value = "移除拼单参与人ID")
    private String removeUserId;

    @ApiModelProperty(value = "商户ID", required = true)
    @NotEmpty(message = "商户ID 不能为空")
    private String partnerId;

    @ApiModelProperty(value = "门店ID", required = true)
    @NotEmpty(message = "门店ID 不能为空")
    private String shopId;
}
