/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CollageOrderServiceImpl
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: hui.miao
 * @date: 2020/10/11 20:55
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.impl;


import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.log.LogTreadLocal;
import cn.freemud.base.util.DateUtil;
import cn.freemud.entities.dto.wechat.GetAuthorizerRequestDto;
import cn.freemud.entities.dto.wechat.GetTokenResponseDto;
import cn.freemud.entities.dto.wechat.GroupBuyResp;
import cn.freemud.entities.vo.QueryOrderVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.service.thirdparty.EcologyAdminApplicationClient;
import cn.freemud.service.thirdparty.WeChatClient;
import com.alibaba.fastjson.JSONObject;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import com.freemud.application.sdk.api.ordercenter.enums.ResponseResultEnum;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderSettlementResp;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
import com.freemud.sdk.api.assortment.order.request.order.GroupBuyRequest;
import com.freemud.sdk.api.assortment.order.response.order.GroupBuyResponse;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.WechatGroupBuyVo;
import cn.freemud.enums.OrderMarketType;
import cn.freemud.service.CollageOrderService;
import cn.freemud.utils.ResponseUtil;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrderByIdResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Service
@Slf4j
public class CollageOrderServiceImpl implements CollageOrderService {
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private OrderCenterSdkService orderCenterSdkService;
    @Autowired
    private AssortmentCustomerInfoManager customerInfoManager;
    @Autowired
    private EcologyAdminApplicationClient ecologyAdminApplicationClient;
    @Autowired
    private WeChatClient weChatClient;

    /**
     * 创建拼单订单
     */
    @Override
    public BaseResponse create(CreateOrderVo createOrderVo) {
        // 标记订单类型-4 拼单
        createOrderVo.setMarketingType(OrderMarketType.COLLAGE.getIndex());
        return this.orderService.createOrderNew(createOrderVo);
    }

    /**
     * 查询拼单详情
     * @param queryOrderVo
     * @return
     */
    @Override
    public BaseResponse queryCollageOrderById(QueryOrderVo queryOrderVo) {
        return this.orderService.queryCollageOrderById(queryOrderVo.getOperation(),queryOrderVo.getSessionId(), queryOrderVo.getOid(),queryOrderVo.getPartnerId(),queryOrderVo.getChannelType());
    }

    /**
     * 创建群收款
     * @param requestVo
     * @return
     */
    @Override
    public BaseResponse createGroupBuy(WechatGroupBuyVo requestVo) {
        // 获取拼单订单信息，若类型不是拼单直接返回报错
        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId(requestVo.getOrderCode());
        baseQueryOrderRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
        QueryOrderByIdResponse response = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);

        if (!ResponseResultEnum.SUCCESS.getCode().equals(response.getErrcode()) || response.getData() == null) {
            return ResponseUtil.error(ResponseResult.ORDER_NOT_EXIST);
        }
        QueryOrdersResponse.DataBean.OrderBean order = response.getData();

        if (null == order.getMarketingType() || OrderMarketType.COLLAGE.getIndex() != order.getMarketingType()) {
            return ResponseUtil.error(ResponseResult.ORDER_NOT_EXIST);
        }

        // 根据sessionId获取当前用户信息以及appid
        AssortmentCustomerInfoVo userInfo = customerInfoManager.getCustomerInfoByObject(requestVo.getSessionId());
        GetAuthorizerRequestDto getAuthorizerRequestDto = new GetAuthorizerRequestDto();
        getAuthorizerRequestDto.setPartnerId(requestVo.getPartnerId());
        getAuthorizerRequestDto.setAuthorizerAppid(userInfo.getWxAppId());

        // 通过partnerId以及appid获取access_token
        log.info("collage access_token request partnerId:{} appId:{}", requestVo.getPartnerId(), userInfo.getWxAppId());
        GetTokenResponseDto getTokenResponseDto = ecologyAdminApplicationClient.getAuthorizerAccessToken(getAuthorizerRequestDto);
        String accessToken = getTokenResponseDto.getResult().getAccessToken();
        log.info("collage access_token response access_token:{}", accessToken);

        // 构造群收款订单创建请求对象
        GroupBuyRequest groupBuyRequest = new GroupBuyRequest();

        // 订单编号
        groupBuyRequest.setOut_trade_no(order.getOid());

        // 收款人（拼单发起人）openId
        groupBuyRequest.setRecv_openid(userInfo.getOpenId());

        // 付款人列表（查询拼单订单详情，根据商品自动计算价格，订单级别优惠分摊）
        GroupBuyRequest.PayList payList = new GroupBuyRequest.PayList();
        List<GroupBuyRequest.UserInfo> userInfoList = new ArrayList<>();

        List<QueryOrdersResponse.DataBean.OrderBean.ProductBean> productList = order.getProductList();

        // 群收款支付用户列表
        List<String> payerOpenIdList = productList.stream().filter(product -> !userInfo.getMemberId().equals(product.getUserId())).map(QueryOrdersResponse.DataBean.OrderBean.ProductBean::getOpenId).distinct().collect(Collectors.toList());
        // 组装群收款付款人列表
        GroupBuyRequest.UserInfo groupBuyUserInfo;
        for (String payerOpenId : payerOpenIdList) {
            Long amount = productList.stream().filter(product -> payerOpenId.equals(product.getOpenId())).map(QueryOrdersResponse.DataBean.OrderBean.ProductBean::getSalePrice).reduce(Long::sum).get();

            groupBuyUserInfo = new GroupBuyRequest.UserInfo();
            groupBuyUserInfo.setOpenid(payerOpenId);
            groupBuyUserInfo.setAmount(Integer.parseInt(String.valueOf(amount)));
            userInfoList.add(groupBuyUserInfo);
        }

        payList.setUser_info(userInfoList);
        groupBuyRequest.setPay_list(payList);

        // 业务场景 1 其他（暂未解决后端上传收款图问题）
        groupBuyRequest.setScene(1);

        // 描述信息 Desc（订单商户+日期）
        GroupBuyRequest.Desc desc = new GroupBuyRequest.Desc();
        desc.setText_desc(order.getShopName() + DateUtil.getCurrentDate(DateUtil.FORMAT_yyyyMMdd));
        groupBuyRequest.setDesc(desc);

        log.info("collage groupBuy request param:{}", groupBuyRequest);
        GroupBuyResponse groupBuyResponse = weChatClient.groupBuyCreateOrder(accessToken, groupBuyRequest);
        log.info("collage groupBuy response return:{}", groupBuyResponse);

        if (null != groupBuyResponse && groupBuyResponse.getErrcode() == 0) {
            GroupBuyResp groupBuyResp = new GroupBuyResp();
            groupBuyResp.setGroupBuyOrderId(groupBuyResponse.getOrder_id());
            return ResponseUtil.success(groupBuyResp);
        } else {
            return ResponseUtil.error("创建群收款失败");
        }
    }
}
