package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.CollageOrderRequestVo;
import cn.freemud.service.impl.CollageOrderServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0.0
 * @Description:
 * @author: hui.miao
 * @date: 2020-09-28 15:36
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableAutoConfiguration
public class CollageOrderServiceTest {

    @Autowired
    private CollageOrderServiceImpl collageOrderService;

    @Test
    public void queryCollageOrder() {
        CollageOrderRequestVo request = CollageOrderRequestVo.builder()
                .sessionId("")
                .createCollageUserId("3600667734347310003")
                .partnerId("partner1")
                .shopId("store1")
                .build();
        BaseResponse response = collageOrderService.queryCollageOrder(request);
        Assert.assertNotNull(response.getCode());
    }

    @Test
    public void createCollageOrder() {
        CollageOrderRequestVo request = CollageOrderRequestVo.builder()
                .sessionId("c05bf8184c7e7783be35c7fb1d4d04d4f03b3b6f")
                .partnerId("partner1")
                .shopId("store1")
                .build();
        BaseResponse response = collageOrderService.createCollageOrder(request);
        Assert.assertNotNull(response.getCode());
    }

    @Test
    public void cancelCollageOrder() {
        CollageOrderRequestVo request = CollageOrderRequestVo.builder()
                .sessionId("c05bf8184c7e7783be35c7fb1d4d04d4f03b3b6f")
                .partnerId("partner1")
                .shopId("store1")
                .build();
        BaseResponse response = collageOrderService.cancelCollageOrder(request);
        Assert.assertNotNull(response.getCode());
    }
}
