package cn.freemud.entities.dto.order;

import cn.freemud.entities.vo.CreateOrderVo;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import lombok.Data;

@Data
public class CreatePrepayRequestDto {
    /**
     * 商户id
     */
    private String partnerId;
    /**
     * appid
     */
    private String wxAppId;
    /**
     * 用户openId
     */
    private String openId;
    /**
     * 人脸识别码code
     */
    private String faceCode;
    /**
     * 会员卡code
     */
    private String cardCode;
    /**
     * 支付渠道码
     */
    private String payCode;
    /**
     * 父订单，如果不存在，则值与productOrderBean一致
     */
    private OrderBeanV1 fatherOrderBean;
    /**
     * 商品订单
     */
    private OrderBeanV1 productOrderBean;
    /**
     * 总金额
     */
    private long totalAmount;
    /**
     * 会员卡支付金额
     */
    private int cardAmount;
    /**
     * 是否开发票
     */
    private int needInvoice;
    /**
     * 订单扩展信息
     */
    private OrderExtInfoDto orderExtInfoDTO;
    /**
     * 交易请求号
     */
    private String transId;

    private OrderClientType orderClient;

    /**
     * 使用电子风味卡
     */
    private CreateOrderVo.UnionPayCard unionPayCard;
    private String storeId;
    private String channel;

    private String sessionId;
}
