package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.bo.goods.ManagerServiceBO;
import cn.freemud.demo.entities.bo.goods.PlatformApportionBO;
import cn.freemud.demo.entities.bo.goods.ShoppingCartGoodsApportionBO;
import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.demo.manager.coupon.CouponService;
import cn.freemud.demo.manager.customer.CustomerService;
import cn.freemud.demo.manager.product.ProductService;
import cn.freemud.demo.manager.promotion.PromotionService;
import cn.freemud.demo.manager.store.StoreService;
import cn.freemud.entities.vo.GetShoppingCartGoodsApportionRequestVo;
import cn.freemud.utils.BeanUtil;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class ApportionBOAdapter {

    @Autowired
    @Qualifier("KgdCustomerService")
    private CustomerService kgdCustomerServIce;

    @Autowired
    @Qualifier("KgdProductService")
    private ProductService kgdProductService;

    @Autowired
    @Qualifier("KgdStoreService")
    private StoreService kgdStoreService;

    @Autowired
    @Qualifier("KgdPromotionService")
    private PromotionService kgdPromotionService;

    @Autowired
    @Qualifier("KgdCouponService")
    private CouponService kgdCouponService;

    @Resource
    private MapperFacade mapperFacade;

    public ShoppingCartGoodsApportionBO convert2ApportionBO(String bizType, GetShoppingCartGoodsApportionRequestVo baseRequestDTO) {

        ShoppingCartGoodsApportionBO updateAddGoodsBO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            updateAddGoodsBO = createMCoffeeBO(baseRequestDTO);
        } else {
            updateAddGoodsBO = createPlatformBO(baseRequestDTO);
        }
        return updateAddGoodsBO;

    }

    private ShoppingCartGoodsApportionBO createPlatformBO(GetShoppingCartGoodsApportionRequestVo baseRequestDTO) {


        PlatformApportionBO platformApportionBO = BeanUtil.convertBean(baseRequestDTO.getShoppingCartInfoRequestVo(), PlatformApportionBO::new);

        ShoppingCartGoodsApportionBO.PremiumExchangeActivity premiumExchangeActivity = mapperFacade.map(baseRequestDTO.getPremiumExchangeActivity(), ShoppingCartGoodsApportionBO.PremiumExchangeActivity.class);
        platformApportionBO.setPremiumExchangeActivity(premiumExchangeActivity);

        ManagerServiceBO managerService = ManagerServiceBO.builder()
                .customerService(kgdCustomerServIce)
                .productService(kgdProductService)
                .couponService(kgdCouponService)
                .storeService(kgdStoreService)
                .promotionService(kgdPromotionService)
                .build();
        platformApportionBO.setManagerService(managerService);

        return platformApportionBO;

    }

    private ShoppingCartGoodsApportionBO createMCoffeeBO(GetShoppingCartGoodsApportionRequestVo baseRequestDTO) {
        return null;
    }

}
