package cn.freemud.entities.dto.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/12/3 下午4:15
 * @description :
 */
@Data
public class CheckAndCancelResponseDTO {

    public static int SUCCESS = 1;
    public static int PROTION_FAIL = 2;
    public static int FAIL = 3;

    @ApiModelProperty(value = "作废结果，1：已全部作废，2：部分作废失败，3：不可作废", required = true)
    private Integer resultCode;

    @ApiModelProperty(value = "作废结果说明，如resultCode为3时，代表不可作废的原因（如：xx券已核销）", required = true)
    private String memo;

    @ApiModelProperty(value = "每个券对应的处理结果", required = true)
    private List<CouponCancelMsg> resultList;
}
