/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderPayResponseDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/25 17:10
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.response.payment;

import com.freemud.application.sdk.api.ordercenter.entities.PayItem;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.ArrayList;
import java.util.List;

@NoArgsConstructor
@Data
@ToString
public class OrderPayResponse {
    /**
     * pay_transId : 84617583993553153103
     * pay_id : 微信小程序支付
     * pay_ebcode : 10007
     * fmId : ZHL1407O1555247503
     * pay_order : {"appid":"wx3ab08e23966343fe","package":"prepay_id=wx25143630149413bcd9fbad100070370076","nonce_str":"-610630281","sign":"D320B2B74D858EBE16841F43AE70E757","timestamp":"1527230190","signType":"MD5"}
     * statusCode : 100
     */

    /**
     * 支付交易序号
     */
    private String payTransId;

    /**
     * 支付方式描述
     */
    private String payId;

    private String payEbcode;

    private String msg;

    /**
     * 非码交易ID
     */
    private String fmId;

    private PayOrderBean payOrder;

    private Integer statusCode;

    private String openId;

    private String partnerId;

    private String wxAppid;

    private String orderId;
    private String payMode;
    private List<PayItem> payItem = new ArrayList<>();

    @NoArgsConstructor
    @Data
    public static class PayOrderBean {
        /**
         * appid : wx3ab08e23966343fe
         * package : prepay_id=wx25143630149413bcd9fbad100070370076
         * nonce_str : -610630281
         * sign : D320B2B74D858EBE16841F43AE70E757
         * timestamp : 1527230190
         * signType : MD5
         */

        private String appid;

        private String packageX;

        private String nonceStr;

        /**
         * 签名
         */
        private String sign;

        private String timestamp;

        /**
         * 签名方式
         */
        private String signType;

        private String aliPayOrder;
    }

}
