package cn.freemud.demo.entities.dto.goods.add.list;

import cn.freemud.demo.entities.CalculationDiscountBO;
import cn.freemud.demo.entities.ChooseGoodsBO;
import cn.freemud.demo.entities.dto.goods.add.update.BaseUpdateGoodsQtyVO;
import cn.freemud.entities.vo.ActivityClassifyCouponBean;
import cn.freemud.entities.vo.ActivityTip;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.ShoppingCartCustomerScoreVo;
import lombok.Builder;
import lombok.Data;

import java.util.List;

@Data
public class PlatformListCartGoodsVO extends BaseListCartGoodsVO {


    /**
     * 前端用来提示的信息
     */
    private String toastMsg;
    /**
     * 购物车中商品价格或有效性是否发生变化
     */
    private Boolean changed;
    private String uid;


    /**
     * 商品额外的属性
     */
    List<CartGoods> products;
    /**
     * 商品总数
     */
    private Integer productsCount;
    /**
     * 活动信息
     */
    private ActivityTip activityTip;

    /**
     * 原总价
     */
    private Long originalTotalAmount;
    /**
     * 现总价
     */
    private Long totalAmount;
    /**
     * 总折扣价
     */
    private Long totalDiscountAmount;

    /**
     * 新包装费（该字段给新版本前端展示，使其好计算）
     */
    private Long newPackAmount;

    /**
     * 优惠券折扣
     */
    private Long couponDiscount;

    /**
     * 满减折扣
     */
    private Long fullDiscount;
    /**
     * svc卡支付描述
     */
    private String svcDiscountDesc;

    /**
     * 可用优惠券列表
     */
    private ActivityClassifyCouponBean availableCoupon;

    private ActivityTip buyOneGetActivity;
    /**
     * 积分抵扣优惠
     */
    private ShoppingCartCustomerScoreVo customerScoreVo;
    /**
     * 起送费
     */
    private Long freeDeliveryPrice;
    /**
     * 会员卡原价
     */
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    private Integer cardDiscountAmount;

    /**
     * 配送费
     */
    private Long deliveryAmount;

    /**
     * 减免后配送费
     */
    private Long discountDeliveryAmount;

    /**
     * 满多少额度 减免
     */
    private Long thresholdAmount;

    /**
     * 是否参加满额减免
     */
    @Builder.Default
    private Boolean isDiscountDelivery = false;

    /**
     * 满额减配送费描述
     */
    private String deliveryDiscountDesc;

    /**
     * 减免后配送费
     */
    private String discountDeliveryActivityCode;

    /**
     * 配送费为零的原因：0:正常,1:超出配送范围
     */
    private Integer deliveryFeeZeroReason;

    /**
     * 代金券
     */
    private String couponCode;

    /**
     * 运费券
     */
    private String freightCouponCode;

    /**
     * 麦咖啡-咖啡月卡价格
     */
    private Long payCardFee;
    /**
     * svc卡支付金额
     */
    private String svcPayAmount;

    /**
     * 购物车版本号
     */
    private Integer carVer;

    /**
     * 总的优惠信息集合
     */
    private List<CalculationDiscountBO.CalculationDiscountResult.Discount> discounts;

    /**
     * 商品优惠信息
     */
    private List<CalculationDiscountBO.CalculationDiscountResult.Goods> goods;

    /**
     * 用户可以选择的商品
     */
    private List<ChooseGoodsBO> chooseGoods;



}
