package cn.freemud.entities.dto.promotion;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ActivityVO {
    @ApiModelProperty(value="活动号", name="activityCode", example="DTTJ201988887777")
    private String activityCode;
    @ApiModelProperty(value="活动名称", name="activityName", example="单品特价")
    private String activityName;
    @ApiModelProperty(value="活动描述", name="activityDesc", example="限时特价，速抢")
    private String activityDesc;
    @ApiModelProperty(value="活动开始时间", name="startTime", example="2019-06-14 03:00:00")
    private Date startTime;
    @ApiModelProperty(value="活动结束时间", name="startTime", example="2019-06-15 03:59:59")
    private Date endTime;
    @ApiModelProperty(value="活动类型", name="activityType", example="2")
    private Integer activityType;
    @ApiModelProperty(value="活动子类型", name="activitySubType", example="1")
    private Integer activitySubType;
    @ApiModelProperty(value="活动子来源", name="activitySource", example="1")
    private String activitySource;
    @ApiModelProperty(value="活动子优先级", name="priority", example="1")
    private Integer priority;
    @ApiModelProperty(value="均摊类型", hidden = true, name="type", example="1")
    private Integer type;
    @ApiModelProperty(value="是否均摊", hidden = true, name="isApportion", example="1")
    private Integer isApportion;
    @ApiModelProperty(value="活动审核状态", name="auditStatus", example="1")
    private Integer auditStatus;
    @ApiModelProperty(value="活动状态", name="activityStatus", example="1")
    private Integer activityStatus;
    @ApiModelProperty(value="创建时间", name="createTime", example="2019-06-14 09:00:00")
    private Date createTime;
    @ApiModelProperty(value="创建者", name="creator", example="隔壁老王")
    private String creator;

    private Date updateTime;
    @ApiModelProperty(value="最后更新者", name="creator", example="隔壁老王")
    private String updater;
    @ApiModelProperty(value="商户号", name="partnerCode", example="1234")
    private String partnerCode;
    @ApiModelProperty(value="优惠次数（适用于每满减）", name="discountTimes", example="3")
    private Integer discountTimes;
    @ApiModelProperty(value="总次数", hidden = true, name="totalTimes", example="100")
    private Integer totalTimes;
    @ApiModelProperty(value="券有效期开始时间", name="validityPeriodStart", example="2019-06-14 03:00:00")
    private Date validityPeriodStart;
    @ApiModelProperty(value="券有效期结束时间", name="validityPeriodEnd", example="2019-06-14 03:59:59")
    private Date validityPeriodEnd;
    @ApiModelProperty(value="券有效期时长", hidden = true, name="validityPeriod", example="1")
    private Integer validityPeriod;
    @ApiModelProperty(value="用户限制时间单位", name="unit", example="W")
    private String unit;

    private Integer couponType;
    @ApiModelProperty(value="活动共享/不共享（现阶段仅用于开个店）", name="isShared", example="1")
    private Integer isShared;
    @ApiModelProperty(value="会员级别", name="memberLevel", example="1,2,3")
    private String memberLevel;
    @ApiModelProperty(value="券延迟生效时长", hidden = true, name="delayTimes", example="1")
    private Integer delayTimes;
    /**
     * 延迟生效单位或用户限制的时间单位 s：秒、m：分、H：时、D：天 W：周、M：月、Y：年
     */
    @ApiModelProperty(value="券延迟生效单位", hidden = true, name="delayUnit", example="D")
    private String delayUnit;
    @ApiModelProperty(value="渠道", name="channel", example="pickup")
    private String channel;
    @ApiModelProperty(value="活动最大优惠金额（分）", name="maxMoney", example="10000")
    private Integer maxMoney;
    @ApiModelProperty(value="每用户限制次数", name="everybodyLimitTimes", example="1")
    private Integer everybodyLimitTimes;
    @ApiModelProperty(value="最小数量", name="minNum", example="1")
    private Integer minNum;
    @ApiModelProperty(value="最大数量", name="maxNum", example="1")
    private Integer maxNum;
    @ApiModelProperty(value="是否共享库存（根据benefitSeq判断）", hidden = true, name="isShareStock", example="1")
    private Integer isShareStock;
    @ApiModelProperty(value="活动状态", name="activityState", example="1")
    private Integer activityState;
    @ApiModelProperty(value="小程序id", name="appId", example="1")
    private String appId;
    @ApiModelProperty(value="券码活动号", name="couponActiveCode", example="1")
    private String couponActiveCode;
    @ApiModelProperty(value="新/老用户", name="isNewUser", example="1")
    private Short isNewUser;
    @ApiModelProperty(value="是否同步微信卡包", name="isSyncCardHolder", example="1")
    private Short isSyncCardHolder;
    @ApiModelProperty(value="顾客标签", name="customerLabel", example="1,3,5")
    private String customerLabel;
    @ApiModelProperty(value="OA编号", name="oaCode", example="OA00000000001")
    private String oaCode;
    @ApiModelProperty(value = "同步渠道", name = "syncChannel", example = "fm,meituan,ebai")
    private String syncChannel;
    @ApiModelProperty(value="优惠信息", name="benefits")
    private List<ActivityBenefitVO> benefits;
    @ApiModelProperty(value="商品限制列表", name="goods")
    private List<ActivityGoodsVO> goods;
    @ApiModelProperty(value="组织限制列表", name="orgs")
    private List<ActivityOrgVO> orgs;
    @ApiModelProperty(value="门店限制列表", name="stores")
    private List<ActivityStoreVO> stores;
    @ApiModelProperty(value="时间段列表", name="times")
    private List<ActivityTimeVO> times;
    @ApiModelProperty(value="赠送商品列表", name="sendGoods")
    private List<ActivitySendGoodsVO> sendGoods;
    @ApiModelProperty(value="周期循环列表（废弃，仅会员周期送使用）", name="cycles")
    private ActivityStockVO activityStock;
    @ApiModelProperty(value="赠券信息列表", name="sendCoupons")
    private List<ActivitySendCouponVO> sendCoupons;

    private List<ActivityCycleVO> cycles;
    @ApiModelProperty(value="分摊信息列表", name="discountShareInfo")
    private List<ActivityApportionVO> discountShareInfo;

    @ApiModelProperty(value = "标签", name = "label", example = "标签")
    private String label;

    public void setLabel(String label) { this.label = label; }

    public String getLabel() { return label; }

    public Integer getIsShareStock() {
        return isShareStock;
    }

    public void setIsShareStock(Integer isShareStock) {
        this.isShareStock = isShareStock;
    }

    public Integer getMaxMoney() {
        return maxMoney;
    }

    public void setMaxMoney(Integer maxMoney) {
        this.maxMoney = maxMoney;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityDesc() {
        return activityDesc;
    }

    public void setActivityDesc(String activityDesc) {
        this.activityDesc = activityDesc;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getActivitySubType() {
        return activitySubType;
    }

    public void setActivitySubType(Integer activitySubType) {
        this.activitySubType = activitySubType;
    }

    public void setActivityStock(ActivityStockVO activityStock) {
        this.activityStock = activityStock;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getIsApportion() {
        return isApportion;
    }

    public void setIsApportion(Integer isApportion) {
        this.isApportion = isApportion;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdater() {
        return updater;
    }

    public void setUpdater(String updater) {
        this.updater = updater;
    }

    public List<ActivityBenefitVO> getBenefits() {
        return benefits;
    }

    public void setBenefits(List<ActivityBenefitVO> benefits) {
        this.benefits = benefits;
    }

    public List<ActivityGoodsVO> getGoods() {
        return goods;
    }

    public void setGoods(List<ActivityGoodsVO> goods) {
        this.goods = goods;
    }

    public List<ActivityStoreVO> getStores() {
        return stores;
    }

    public void setOrgs(List<ActivityOrgVO> orgs) { this.orgs = orgs; }

    public List<ActivityOrgVO> getOrgs() { return orgs; }

    public void setStores(List<ActivityStoreVO> stores) {
        this.stores = stores;
    }

    public List<ActivityTimeVO> getTimes() {
        return times;
    }

    public void setTimes(List<ActivityTimeVO> times) {
        this.times = times;
    }

    public String getPartnerCode() {
        return partnerCode;
    }

    public void setPartnerCode(String partnerCode) {
        this.partnerCode = partnerCode;
    }

    public Integer getTotalTimes() {
        return totalTimes;
    }

    public void setTotalTimes(Integer totalTimes) {
        this.totalTimes = totalTimes;
    }

    public Date getValidityPeriodStart() {
        return validityPeriodStart;
    }

    public void setValidityPeriodStart(Date validityPeriodStart) {
        this.validityPeriodStart = validityPeriodStart;
    }

    public Date getValidityPeriodEnd() {
        return validityPeriodEnd;
    }

    public void setValidityPeriodEnd(Date validityPeriodEnd) {
        this.validityPeriodEnd = validityPeriodEnd;
    }

    public Integer getCouponType() {
        return couponType;
    }

    public void setCouponType(Integer couponType) {
        this.couponType = couponType;
    }

    public Integer getDiscountTimes() {
        return discountTimes;
    }

    public void setDiscountTimes(Integer discountTimes) {
        this.discountTimes = discountTimes;
    }

    public Integer getIsShared() {
        return isShared;
    }

    public void setIsShared(Integer isShared) {
        this.isShared = isShared;
    }

    public Integer getDelayTimes() {
        return delayTimes;
    }

    public void setDelayTimes(Integer delayTimes) {
        this.delayTimes = delayTimes;
    }

    public String getDelayUnit() {
        return delayUnit;
    }

    public void setDelayUnit(String delayUnit) {
        this.delayUnit = delayUnit;
    }

    public Integer getValidityPeriod() {
        return validityPeriod;
    }

    public void setValidityPeriod(Integer validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public List<ActivitySendGoodsVO> getSendGoods() {
        return sendGoods;
    }

    public void setSendGoods(List<ActivitySendGoodsVO> sendGoods) {
        this.sendGoods = sendGoods;
    }


    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Integer getEverybodyLimitTimes() {
        return everybodyLimitTimes;
    }

    public void setEverybodyLimitTimes(Integer everybodyLimitTimes) {
        this.everybodyLimitTimes = everybodyLimitTimes;
    }

    public Integer getMinNum() {
        return minNum;
    }

    public void setMinNum(Integer minNum) {
        this.minNum = minNum;
    }

    public Integer getMaxNum() {
        return maxNum;
    }

    public void setMaxNum(Integer maxNum) {
        this.maxNum = maxNum;
    }

    public ActivityStockVO getActivityStock() {
        return activityStock;
    }

    public List<ActivitySendCouponVO> getSendCoupons() {
        return sendCoupons;
    }

    public void setSendCoupons(List<ActivitySendCouponVO> sendCoupons) {
        this.sendCoupons = sendCoupons;
    }

    public List<ActivityCycleVO> getCycles() {
        return cycles;
    }

    public void setCycles(List<ActivityCycleVO> cycles) {
        this.cycles = cycles;
    }

    public String getMemberLevel() {
        return memberLevel;
    }

    public void setMemberLevel(String memberLevel) {
        this.memberLevel = memberLevel;
    }

    public String getActivitySource() {
        return activitySource;
    }

    public void setActivitySource(String activitySource) {
        this.activitySource = activitySource;
    }

    public Integer getActivityState() {
        return activityState;
    }

    public void setActivityState(Integer activityState) {
        this.activityState = activityState;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getCouponActiveCode() {
        return couponActiveCode;
    }

    public void setCouponActiveCode(String couponActiveCode) {
        this.couponActiveCode = couponActiveCode;
    }

    public List<ActivityApportionVO> getDiscountShareInfo() {
        return discountShareInfo;
    }

    public void setDiscountShareInfo(List<ActivityApportionVO> discountShareInfo) {
        this.discountShareInfo = discountShareInfo;
    }

    public Short getIsNewUser() {
        return isNewUser;
    }

    public void setIsNewUser(Short isNewUser) {
        this.isNewUser = isNewUser;
    }

    public Short getIsSyncCardHolder() {
        return isSyncCardHolder;
    }

    public void setIsSyncCardHolder(Short isSyncCardHolder) {
        this.isSyncCardHolder = isSyncCardHolder;
    }

    public String getCustomerLabel() {
        return customerLabel;
    }

    public void setCustomerLabel(String customerLabel) {
        this.customerLabel = customerLabel;
    }

    public String getOaCode() {
        return oaCode;
    }

    public void setOaCode(String oaCode) {
        this.oaCode = oaCode;
    }

    public String getSyncChannel() {
        return syncChannel;
    }

    public void setSyncChannel(String syncChannel) {
        this.syncChannel = syncChannel;
    }
}