package com.freemud.application.sdk.api.ordercenter.request;

import com.freemud.application.sdk.api.ordercenter.request.create.OrderItemCreateReq;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: GroupCreateOrderRequest
 * @Description: 简单描述下这个类是做什么用的
 * @author: qin.zhou
 * @date: 2019/9/318:54
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class GroupCreateOrderRequest {

    //商户号
    private String partnerId;

    //门店编号
    private String storeId;

    //下单渠道必填，根据此字段的值判断是自营或第三方，来走不同的状态机 详细见 orderClientType枚举
    private Integer orderClient;


    //商户自己生成的订单号
    private String companySelfCode;

    //订单编号
    private String orderCode;

    //门店名
    private String storeName;

    //英文门店名
    private String storeNameEn;

    //商户名
    private String partnerName;

    //门店全局唯一编号
    private String storeUnifyId;

    //用户ID
    private String userId;

    //用户姓名
    private String userName;

    //订单类型 店内自取实时-1常规堂食 店内自取预约-2预约堂食 店外快递实时-3常规外卖，
    // 店外快递预约-4预约外卖 店外自取实时-5常规自取 店外自取预约-6预约自取
    private Integer orderType;

    //是否需要开发票
    private Boolean needInvoice;

    //订单备注
    private String note;

    //扩展字段
    private String extInfo;

    //桌台号
    private String barCounter;

    //就餐人数
    private Integer dinersNumber;

    //订单商信息
    List<OrderItemCreateReq> orderItemList;

    //操作人
    private String operator;

}
