package cn.freemud.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PayRefundStatus
 * @Package cn.freemud.enums
 * @Description:
 * @author: jiaxin.liu
 * @date: 2019/5/27 15:09
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum PayRefundStatus {
    SUCCESS(1,"退款成功"),
    FAIL(2,"退款失败"),
    RUNNING(4,"退款中"),
    /**
     * 额外状态码 用于判断逻辑,
     */
    NOT_SUFFICIENT_FUNDS(8200201,"余额不足");

    private Integer code;
    private String desc;

    PayRefundStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PayRefundStatus getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (PayRefundStatus payStatus : values()) {
            if (payStatus.getCode().equals(code)) {
                return payStatus;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
