package com.freemud.sdk.api.assortment.shoppingcart.util;

import cn.freemud.base.constant.Version;
import cn.freemud.base.entity.BaseResponse;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CartResponseConstant;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CartResponseUtil
 * @Package com.freemud.sdk.api.assortment.shoppingcart.util
 * @Description:
 * @author: jiaxin.liu
 * @date: 2019/4/11 11:02
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public class CartResponseUtil {

    public static <T> BaseResponse<T> success() {
        return new BaseResponse<>(Version.VERSION_1, CartResponseConstant.SUCCESS.getCode(), "success");
    }

    public static <T> BaseResponse<T> success(T t) {
        return new BaseResponse<>(CartResponseConstant.SUCCESS.getCode(), "success", Version.VERSION_1, t);
    }

    public static <T> BaseResponse<T> error(String message) {
        return new BaseResponse<>(Version.VERSION_1, CartResponseConstant.FAIL.getCode(), message);
    }
    public static <T> BaseResponse<T> error(String message,T t) {
        return new BaseResponse<>(CartResponseConstant.FAIL.getCode(), message, Version.VERSION_1, t);
    }
}
