package com.freemud.sdk.api.assortment.order.service;

import com.freemud.application.sdk.api.ordercenter.request.QueryAfterSalesOrderConditionsReq;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.AfterSalesListResp;
import com.freemud.sdk.api.assortment.order.request.order.*;
import com.freemud.sdk.api.assortment.order.response.order.*;

public interface OrderCenterSdkService {

    /**
     * 创建订单
     *
     * @return
     */
    public CreateOrderResponse createOrderFlow(CreateOrderRequest createOrderRequest);

    /**
     * 创建父子订单
     */
    CreateFatherSonOrderResponse createFatherSonOrder(CreateFatherSonOrderRequest createFatherSonOrderRequest);

    CreateOrderResponse createOrder(BaseCreateOrderRequest baseCreateOrderRequest);

    /**
     * 订单支付确认 C端
     */
    PayAccessResponse payAccess(ConfirmOrderRequest confirmOrderRequest);

    /**
     * 根据订单编号查询订单信息 C端
     */
    QueryOrderByIdResponse queryOrderById(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 条件查询订单列表 C端
     */
    QueryOrdersResponse queryOrders(QueryOrdersRequest queryOrdersRequest);

    /**
     * 删除订单 C端
     */
    BaseOrderResponse deleteOrder(DeleteOrderRequest deleteOrderRequest);

    /**
     * 订单申请退款 C端
     */
    BaseOrderResponse orderRefund(OrderRefundRequest orderRefundRequest);

    /**
     * 编辑订单 C端
     */
    BaseOrderResponse orderEdit(OrderEditRequest orderEditRequest);

    /**
     * 订单取消 C端，POS
     */
    BaseOrderResponse orderCancel(CancelOrderRequest cancelOrderRequest);

    /**
     * 获取取餐排队号  C端
     */
    BaseOrderResponse queryOrderQueueIndex(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 获取当前门店接单数 C端
     */
    BaseOrderResponse queryStoreOrderQuantity(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 根据订单ID查询订单状态操作记录 C端
     */
    OrderStatusTrackingInfoResponse getOrderStatusTrackingInfoByOid(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 轮询订单 POS
     */
    QueryOrdersResponse repeatGetOrders(RepeatQueryOrdersRequest repeatQueryOrdersRequest);

    /**
     * 订单确认接单 POS
     */
    BaseOrderResponse orderConfirmTake(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单POS拒单 POS
     */
    BaseOrderResponse orderReject(CancelOrderRequest cancelOrderRequest);

    /**
     * 订单配送中 POS
     */
    BaseOrderResponse orderSend(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单确认送达 POS
     */
    BaseOrderResponse orderAffirm(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单同意并退款完成 POS
     */
    BaseOrderResponse refundComplete(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单退款完成 POS
     */
    BaseOrderResponse orderRefundComplete(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单同意并退货完成 POS
     */
    BaseOrderResponse refundReturn(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单拒绝退款 POS
     */
    BaseOrderResponse orderRefundReject(CancelOrderRequest cancelOrderRequest);

    /**
     * 自提订单制作完成 POS
     */
    BaseOrderResponse orderDone(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 条件查询门店订单 POS
     */
    QueryOrdersResponse getOrderListByConditions(QueryOrdersByConditionsRequest queryOrdersByConditionsRequest);

    /**
     * 条件查询门店订单
     */
    QueryOrdersResponse getOrderListByES(QueryOrdersByConditionsRequest queryOrdersByConditionsRequest);

    /**
     * 批量查询订单（供POS拉单使用）
     *
     * @param request
     * @return
     */
    BatchQueryResponse batchQuery(BatchQueryRequest request);

    /**
     * 统计每日营业额
     *
     * @param request
     * @return
     */
    GetStatisticStoreOrderReportResponse getStatisticStoreOrderReport(GetStatisticStoreOrderReportRequest request);

    /**
     * 根据订单ID修改第三方配送信息
     *
     * @param request
     * @return
     */
    OrderBaseResponse updateDeliveryInfoById(UpdateDeliveryInfoByIdRequest request);

    /**
     * 综合条件查询订单
     *
     * @param request
     * @return
     */
    OrderDownloadResponse orderDownload(OrderDownloadRequest request);

    /**
     * 根据订单ID查询订单详情(B端后台用)
     *
     * @param request
     * @return
     */
    @Deprecated
    OrderDetailResponse getByIdForParentProduct(BaseQueryOrderRequest request);

    /**
     * 查询售后单列表
     *
     * @param request
     * @return
     */
    QueryRefundOrderResponse queryAfterSalesList(QueryRefundOrdersRequest request);

    /**
     * POS拉售后单
     *
     * @param request
     * @return
     */
    BatchQueryAfterSalesResponse batchQueryAfterSales(BatchQueryAfterSalesRequest request);

    /**
     * 批量查询订单状态
     *
     * @param request
     * @return
     */
    BatchOrdersStateResponse batchQueryOrderStatus(BatchOrdersStateRequest request);

    /**
     * 批量查询订单明细
     *
     * @param request
     * @return
     */
    QueryOrdersResponse batchQueryByCodes(BatchQueryByCodesRequest request);

    /**
     * 查询父子订单
     *
     * @param request
     * @return
     */
    QueryRelatedOrderByCodeResp queryRelatedOrderByCode(QueryRelatedOrderByCodeRequest request);

    /**
     * 修改第三方订单号
     *
     * @param assortmentSdkUpdateThirdOrderCodeRequest
     * @return
     */
    BaseOrderResponse updateThirdOrderCode(AssortmentSdkUpdateThirdOrderCodeRequest assortmentSdkUpdateThirdOrderCodeRequest);

    /**
     * 更新三方配送单异常
     */
    OrderBaseResponse updateDeliveryAbnormal(AssortmentUpdateDeliveryAbnormalRequest request);

    /**
     * 围餐创建订单
     */
    CreateOrderResponse createGroupOrder(AssortmentGroupCreateOrderRequest createOrderRequest);

    /**
     * 围餐订单完成
     */
    AssortmentAffirmGroupOrderResponse affirmGroupOrder(AssortmentGroupOrderAffirmRequest orderAffirmRequest);

    /**
     * 修改订单(围餐)
     */
    OrderDetailResponse updateGroupOrder(AssortmentGroupUpdateOrderRequest createOrderRequest);

    /**
     * 清空订单商品
     */
    AssortmentAffirmGroupOrderResponse clearGroupOrder(AssortmentGroupOrderClearRequest groupOrderClearRequest);

    /**
     * 修改订单商品信息
     *
     * @param updateOrderProductInfoRequest
     * @return
     */
    OrderDetailResponse updateOrderItem(AssortmentSdkUpdateOrderProductInfoRequest updateOrderProductInfoRequest);

    /**
     * 清台
     *
     * @param clearTableRequest
     * @return
     */
    OrderBaseResponse clearTableNumber(ClearTableRequest clearTableRequest);

    /**
     * 获取订单加菜
     *
     * @param orderCommonRequest
     * @return
     */
    AssortmentOrderGetOrderAddProductResponse getOrderAddProduct(OrderCommonRequest orderCommonRequest);

    /**
     * 分页查询售后单(es)
     */
    AfterSalesListResp queryAfterSalesListES(QueryAfterSalesOrderConditionsReq queryRequest, String trackNo);

    /**
     * 查询售后单详情(es)
     * @param orderCode
     * @param partnerId
     * @param trackNo
     * @return
     */
    QueryOrderByIdResponse queryOrderByCodeES(String orderCode, String partnerId, String trackNo);
}
