package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.bo.goods.ShoppingCartGoodsBO;
import cn.freemud.demo.entities.dto.goods.add.update.BaseUpdateGoodsQtyVO;
import cn.freemud.demo.entities.dto.goods.add.update.MCoffeeUpdateGoodsQtyVO;
import cn.freemud.demo.entities.dto.goods.add.update.PlatformUpdateGoodsQtyVO;
import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.utils.BeanUtil;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class UpdateGoodsQtyVOAdapter {
    @Resource
    private MapperFacade mapperFacade;

    public BaseUpdateGoodsQtyVO convert2AddGoodsVO(String bizType, ShoppingCartGoodsBO baseAddGoodsBO) {
        BaseUpdateGoodsQtyVO baseAddGoodsVO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            baseAddGoodsVO = createMCoffeeVO(baseAddGoodsBO);
        } else {
            baseAddGoodsVO = createPlatformVO(baseAddGoodsBO);
        }
        return baseAddGoodsVO;
    }


    private PlatformUpdateGoodsQtyVO createPlatformVO(ShoppingCartGoodsBO baseAddGoodsBO) {


        PlatformUpdateGoodsQtyVO platformAddGoodsVO = BeanUtil.convertBean(baseAddGoodsBO, PlatformUpdateGoodsQtyVO::new);
        return platformAddGoodsVO;
    }

    private MCoffeeUpdateGoodsQtyVO createMCoffeeVO(ShoppingCartGoodsBO baseAddGoodsBO) {
        MCoffeeUpdateGoodsQtyVO mCoffeeAddGoodsVO = new MCoffeeUpdateGoodsQtyVO();
        return mCoffeeAddGoodsVO;
    }

}
