/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderRestTemplateConfig
 * @Package com.freemud.application.sdk.api.ordercenter.config
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/1 19:18
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.config;

import com.freemud.application.sdk.api.constant.RestTemplateConstant;
import com.freemud.application.sdk.api.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Component
public class OrderRestTemplateConfig {

    @Bean(name = "orderRestTemplate")
    public RestTemplate devOrderRestTemplate(@Autowired OrderCenterProperties orderCenterProperties) {
        Map<String, Integer> map = new HashMap<>(16);
        if (orderCenterProperties.getRetryTimes() != null) {
            map.put(RestTemplateConstant.RETRY_TIMES, orderCenterProperties.getRetryTimes());
        }
        if (orderCenterProperties.getConnectTimeOut() != null) {
            map.put(RestTemplateConstant.CONNECT_TIMEOUT, orderCenterProperties.getConnectTimeOut());
        }
        if (orderCenterProperties.getReadTimeOut() != null) {
            map.put(RestTemplateConstant.READ_TIMEOUT, orderCenterProperties.getReadTimeOut());
        }
        return RestTemplateUtils.getRestTemplateByType(map);
    }

    @Bean(name = "orderDownLoadRestTemplate")
    public RestTemplate orderDownLoadRestTemplate(@Autowired OrderDownLoadCenterProperties orderCenterProperties) {
        Map<String, Integer> map = new HashMap<>(16);
        if (orderCenterProperties.getRetryTimes() != null) {
            map.put(RestTemplateConstant.RETRY_TIMES, orderCenterProperties.getRetryTimes());
        }
        if (orderCenterProperties.getConnectTimeOut() != null) {
            map.put(RestTemplateConstant.CONNECT_TIMEOUT, orderCenterProperties.getConnectTimeOut());
        }
        if (orderCenterProperties.getReadTimeOut() != null) {
            map.put(RestTemplateConstant.READ_TIMEOUT, orderCenterProperties.getReadTimeOut());
        }
        return RestTemplateUtils.getRestTemplateByType(map);
    }

}
