/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderPayDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/25 16:34
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@Data
public class OrderPayDto {
    /**
     * ver : 2
     * reqtype : 73
     * partnerId : 1407
     * store_id : fm99999
     * station_id : 3423
     * operator_id : 3453432424
     * trans_id : 84617583993553153103
     * openid : o_DQc0SgYnth9S0oY2TdlHqQ4YCk
     * business_date : 20170823
     * transactions : [{"amount":1,"pay_ebcode":"10007","undis_amount":0,"products":[{"consume_num":1,"pid":"1188","seq":1188,"sales_type":"NORMAL","price":1390},{"consume_num":1,"pid":"1193","seq":1193,"sales_type":"NORMAL","price":1390}]}]
     */

    /**
     * 版本信息  必须为2
     */
    private Integer ver;
    /**
     * 72 当面付  73 手机App/小程序支付    62 退款  3 冲正   52 支付查询
     * 小程序默认73
     */
    private Integer reqtype;
    /**
     * 商户ID
     */
    private String unifyid;
    /**
     *  支付商户ID
     */
    private String partnerId;
    /**
     * 商家门店号
     */
    private String store_id;
    /**
     * 商家POS机编号（可以使用固定值）随机不重复字符串
     */
    private String station_id;
    /**
     * 营业员编号（可以使用固定值） 随机不重复字符串
     */
    private String operator_id;
    /**
     * 终端交易序号  随机不重复字符串
     */
    private String trans_id;
    /**
     * 用户微信openid
     */
    private String openid;
    /**
     * 用户微信openid 服务商模式使用
     */
    private String sub_openid;
    /**
     * 营业日（可为空），格式：yyyyMMdd
     */
    private String business_date;

    private List<TransactionBean> transactions;

    /**
     * 分账收款信息
     */
    private List<Receiver> receivers;
    @NoArgsConstructor
    @Data
    public static class TransactionBean {
        /**
         * amount : 1
         * pay_ebcode : 10007
         * undis_amount : 0
         * products : [{"consume_num":1,"pid":"1188","seq":1188,"sales_type":"NORMAL","price":1390},{"consume_num":1,"pid":"1193","seq":1193,"sales_type":"NORMAL","price":1390}]
         */
        /**
         * 支付总金额
         */
        private Long amount;
        /**
         * 支付方式（非码提供）10007 微信小程序
         */
        private String pay_ebcode;
        /**
         * 不可打折金额，以分为单位
         */
        private Long undis_amount;

        /**
         * 1为需要开发票 2 不需要开发票
         */
        private Integer invoice_flag;

        private List<ProductBean> products;

        @NoArgsConstructor
        @Data
        public static class ProductBean {

            /**
             * 商品数量
             */
            private Integer consume_num;

            /**
             * 商品ID
             */
            private String pid;

            /**
             * 商品排序
             */
            private Integer seq;

            /**
             * FREE NORMAL
             */
            private String sales_type;

            /**
             * 商品价格
             */
            private Long price;

            /**
             * 商品名称
             */
            private String name;
        }
    }
    @NoArgsConstructor
    @Data
    public static class Receiver{
        /**
         * 分账接收方类型
         */
        private String  type;
        /**
         * 分账接收方帐号
         */
        private String  account;
        /**
         * 分账金额
         */
        private Long  price;
        /**
         * 分账接收方全称
         */
        private String  name;
        /**
         * 分账描述
         */
        private String  description;
    }
}
