package cn.freemud.fuyou.feign;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.fuyou.feign.request.QueryChannelRequest;
import cn.freemud.fuyou.feign.request.QueryResponse;
import cn.freemud.fuyou.feign.request.ReturnScoreRequest;
import cn.freemud.fuyou.feign.request.ScorePayRequest;
import cn.freemud.fuyou.feign.response.UpdateScoreResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

/***
 * 积分
 * dev  url:http://saastestapi.sandload.cn/customer-property-service/
 */
@FeignClient(path = "propertyservice/score/",name = "customer-property-service")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface ScoreFeignClient {

    /**
     * 积分支付
     */
    @PostMapping("pay")
    BaseResponse<UpdateScoreResponse> pay(ScorePayRequest request);


    /**
     * 积分查询
     */
    @PostMapping("query")
    BaseResponse<QueryResponse> query(QueryChannelRequest request);

    /**
     * 积分回退
     */
    @PostMapping("returnScore")
    BaseResponse<UpdateScoreResponse> returnScore(ReturnScoreRequest request);



}
