package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: ClearTableRequest
 * @Description: 简单描述下这个类是做什么用的
 * @author: qin.zhou
 * @date: 2019/9/1020:09
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class ClearTableRequest extends BaseConfig {

    /**
     * 商户号
     */
    @NotEmpty(message = "商户号不能为空")
    private String partnerId;

    /**
     * 门店号
     */
    @NotEmpty(message = "门店号不能为空")
    private String storeId;

    /**
     * 桌号
     */
    @NotEmpty(message = "桌号不能为空")
    private String tableNumber;

    /**
     * 用户id
     */
    private String userId;

    private OpClearTableEnum opClearTableEnum;

    /**
     * closeOrder   关闭订单
     * noOperationOrder 不操作订单
     */
    public enum OpClearTableEnum{
        closeOrder,noOperationOrder
    }

}
