package cn.freemud.entities.vo;

import cn.freemud.entities.ExtraDeliveryDto;
import lombok.Data;

import java.util.List;
import java.util.Objects;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/12/8 下午5:03
 * @description :
 */
@Data
public class DeliveryDto {

    /**
     * 总配送费
     */
    public Long deliveryAmount;
    /**
     * 配送费为零的原因：0:正常,1:超出配送范围
     */
    public Integer deliveryFeeZeroReason;


    /**
     * 附加配送费详细数据  上面的金额 已经加上 这里的金额了
     */
    public List<ExtraDeliveryDto> deliveryAmountList;


    private DeliveryDto() {
    }

    public DeliveryDto(Long deliveryAmount, Integer deliveryFeeZeroReason, List<ExtraDeliveryDto> deliveryAmountList) {
        this.deliveryAmount = deliveryAmount;
        this.deliveryFeeZeroReason = deliveryFeeZeroReason;
        Objects.requireNonNull(deliveryAmountList);
        this.deliveryAmountList = deliveryAmountList;
    }
}
